package com.vmware.vcloud.rest.openapi.model;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * ServiceItem
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-01-11T04:46:40.806Z")
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "serviceItemType", visible = true )
@JsonSubTypes({
  @JsonSubTypes.Type(value = VroWorkflowServiceItem.class, name = "VroWorkflowServiceItem"),
})

public class ServiceItem   {
  @JsonProperty("id")
  private String id = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("serviceItemType")
  private String serviceItemType = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("canExecute")
  private Boolean canExecute = null;

  @JsonProperty("serviceName")
  private String serviceName = null;

  @JsonProperty("serviceId")
  private String serviceId = null;

  @JsonProperty("iconMimeType")
  private String iconMimeType = null;

  @JsonProperty("iconData")
  private String iconData = null;

  @JsonProperty("tenantScoped")
  private Boolean tenantScoped = true;

  @JsonProperty("providerScoped")
  private Boolean providerScoped = false;

  public ServiceItem id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(value = "")


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public ServiceItem name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @ApiModelProperty(value = "")


  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public ServiceItem serviceItemType(String serviceItemType) {
    this.serviceItemType = serviceItemType;
    return this;
  }

   /**
   * Get serviceItemType
   * @return serviceItemType
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull


  public String getServiceItemType() {
    return serviceItemType;
  }

  public void setServiceItemType(String serviceItemType) {
    this.serviceItemType = serviceItemType;
  }

  public ServiceItem description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @ApiModelProperty(value = "")


  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public ServiceItem canExecute(Boolean canExecute) {
    this.canExecute = canExecute;
    return this;
  }

   /**
   * Get canExecute
   * @return canExecute
  **/
  @ApiModelProperty(value = "")


  public Boolean getCanExecute() {
    return canExecute;
  }

  public void setCanExecute(Boolean canExecute) {
    this.canExecute = canExecute;
  }

  public ServiceItem serviceName(String serviceName) {
    this.serviceName = serviceName;
    return this;
  }

   /**
   * Get serviceName
   * @return serviceName
  **/
  @ApiModelProperty(value = "")


  public String getServiceName() {
    return serviceName;
  }

  public void setServiceName(String serviceName) {
    this.serviceName = serviceName;
  }

  public ServiceItem serviceId(String serviceId) {
    this.serviceId = serviceId;
    return this;
  }

   /**
   * Get serviceId
   * @return serviceId
  **/
  @ApiModelProperty(value = "")


  public String getServiceId() {
    return serviceId;
  }

  public void setServiceId(String serviceId) {
    this.serviceId = serviceId;
  }

  public ServiceItem iconMimeType(String iconMimeType) {
    this.iconMimeType = iconMimeType;
    return this;
  }

   /**
   * Get iconMimeType
   * @return iconMimeType
  **/
  @ApiModelProperty(value = "")


  public String getIconMimeType() {
    return iconMimeType;
  }

  public void setIconMimeType(String iconMimeType) {
    this.iconMimeType = iconMimeType;
  }

  public ServiceItem iconData(String iconData) {
    this.iconData = iconData;
    return this;
  }

   /**
   * Get iconData
   * @return iconData
  **/
  @ApiModelProperty(value = "")


  public String getIconData() {
    return iconData;
  }

  public void setIconData(String iconData) {
    this.iconData = iconData;
  }

  public ServiceItem tenantScoped(Boolean tenantScoped) {
    this.tenantScoped = tenantScoped;
    return this;
  }

   /**
   * Get tenantScoped
   * @return tenantScoped
  **/
  @ApiModelProperty(value = "")


  public Boolean getTenantScoped() {
    return tenantScoped;
  }

  public void setTenantScoped(Boolean tenantScoped) {
    this.tenantScoped = tenantScoped;
  }

  public ServiceItem providerScoped(Boolean providerScoped) {
    this.providerScoped = providerScoped;
    return this;
  }

   /**
   * Get providerScoped
   * @return providerScoped
  **/
  @ApiModelProperty(value = "")


  public Boolean getProviderScoped() {
    return providerScoped;
  }

  public void setProviderScoped(Boolean providerScoped) {
    this.providerScoped = providerScoped;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ServiceItem serviceItem = (ServiceItem) o;
    return Objects.equals(this.id, serviceItem.id) &&
        Objects.equals(this.name, serviceItem.name) &&
        Objects.equals(this.serviceItemType, serviceItem.serviceItemType) &&
        Objects.equals(this.description, serviceItem.description) &&
        Objects.equals(this.canExecute, serviceItem.canExecute) &&
        Objects.equals(this.serviceName, serviceItem.serviceName) &&
        Objects.equals(this.serviceId, serviceItem.serviceId) &&
        Objects.equals(this.iconMimeType, serviceItem.iconMimeType) &&
        Objects.equals(this.iconData, serviceItem.iconData) &&
        Objects.equals(this.tenantScoped, serviceItem.tenantScoped) &&
        Objects.equals(this.providerScoped, serviceItem.providerScoped);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, name, serviceItemType, description, canExecute, serviceName, serviceId, iconMimeType, iconData, tenantScoped, providerScoped);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ServiceItem {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    serviceItemType: ").append(toIndentedString(serviceItemType)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    canExecute: ").append(toIndentedString(canExecute)).append("\n");
    sb.append("    serviceName: ").append(toIndentedString(serviceName)).append("\n");
    sb.append("    serviceId: ").append(toIndentedString(serviceId)).append("\n");
    sb.append("    iconMimeType: ").append(toIndentedString(iconMimeType)).append("\n");
    sb.append("    iconData: ").append(toIndentedString(iconData)).append("\n");
    sb.append("    tenantScoped: ").append(toIndentedString(tenantScoped)).append("\n");
    sb.append("    providerScoped: ").append(toIndentedString(providerScoped)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

