package com.vmware.vcloud.rest.openapi.model;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Meta information about a UI Plugin 
 */
@ApiModel(description = "Meta information about a UI Plugin ")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-01-11T04:46:40.806Z")

public class UiPluginMetadata   {
  @JsonProperty("pluginName")
  private String pluginName = null;

  @JsonProperty("vendor")
  private String vendor = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("version")
  private String version = null;

  @JsonProperty("license")
  private String license = null;

  @JsonProperty("link")
  private String link = null;

  @JsonProperty("tenant_scoped")
  private Boolean tenantScoped = null;

  @JsonProperty("provider_scoped")
  private Boolean providerScoped = null;

  @JsonProperty("enabled")
  private Boolean enabled = null;

  public UiPluginMetadata pluginName(String pluginName) {
    this.pluginName = pluginName;
    return this;
  }

   /**
   * Get pluginName
   * @return pluginName
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull


  public String getPluginName() {
    return pluginName;
  }

  public void setPluginName(String pluginName) {
    this.pluginName = pluginName;
  }

  public UiPluginMetadata vendor(String vendor) {
    this.vendor = vendor;
    return this;
  }

   /**
   * Get vendor
   * @return vendor
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull


  public String getVendor() {
    return vendor;
  }

  public void setVendor(String vendor) {
    this.vendor = vendor;
  }

  public UiPluginMetadata description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @ApiModelProperty(value = "")


  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public UiPluginMetadata version(String version) {
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull


  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  public UiPluginMetadata license(String license) {
    this.license = license;
    return this;
  }

   /**
   * Get license
   * @return license
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull


  public String getLicense() {
    return license;
  }

  public void setLicense(String license) {
    this.license = license;
  }

  public UiPluginMetadata link(String link) {
    this.link = link;
    return this;
  }

   /**
   * Get link
   * @return link
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull


  public String getLink() {
    return link;
  }

  public void setLink(String link) {
    this.link = link;
  }

  public UiPluginMetadata tenantScoped(Boolean tenantScoped) {
    this.tenantScoped = tenantScoped;
    return this;
  }

   /**
   * Get tenantScoped
   * @return tenantScoped
  **/
  @ApiModelProperty(value = "")


  public Boolean getTenantScoped() {
    return tenantScoped;
  }

  public void setTenantScoped(Boolean tenantScoped) {
    this.tenantScoped = tenantScoped;
  }

  public UiPluginMetadata providerScoped(Boolean providerScoped) {
    this.providerScoped = providerScoped;
    return this;
  }

   /**
   * Get providerScoped
   * @return providerScoped
  **/
  @ApiModelProperty(value = "")


  public Boolean getProviderScoped() {
    return providerScoped;
  }

  public void setProviderScoped(Boolean providerScoped) {
    this.providerScoped = providerScoped;
  }

  public UiPluginMetadata enabled(Boolean enabled) {
    this.enabled = enabled;
    return this;
  }

   /**
   * Get enabled
   * @return enabled
  **/
  @ApiModelProperty(value = "")


  public Boolean getEnabled() {
    return enabled;
  }

  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UiPluginMetadata uiPluginMetadata = (UiPluginMetadata) o;
    return Objects.equals(this.pluginName, uiPluginMetadata.pluginName) &&
        Objects.equals(this.vendor, uiPluginMetadata.vendor) &&
        Objects.equals(this.description, uiPluginMetadata.description) &&
        Objects.equals(this.version, uiPluginMetadata.version) &&
        Objects.equals(this.license, uiPluginMetadata.license) &&
        Objects.equals(this.link, uiPluginMetadata.link) &&
        Objects.equals(this.tenantScoped, uiPluginMetadata.tenantScoped) &&
        Objects.equals(this.providerScoped, uiPluginMetadata.providerScoped) &&
        Objects.equals(this.enabled, uiPluginMetadata.enabled);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pluginName, vendor, description, version, license, link, tenantScoped, providerScoped, enabled);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UiPluginMetadata {\n");
    
    sb.append("    pluginName: ").append(toIndentedString(pluginName)).append("\n");
    sb.append("    vendor: ").append(toIndentedString(vendor)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    license: ").append(toIndentedString(license)).append("\n");
    sb.append("    link: ").append(toIndentedString(link)).append("\n");
    sb.append("    tenantScoped: ").append(toIndentedString(tenantScoped)).append("\n");
    sb.append("    providerScoped: ").append(toIndentedString(providerScoped)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

