package com.vmware.vcloud.rest.openapi.model;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.vmware.vcloud.rest.openapi.model.Relations;
import com.vmware.vcloud.rest.openapi.model.WsAttribute;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Meta information about an inventory item on a vRealize Orchestrator server 
 */
@ApiModel(description = "Meta information about an inventory item on a vRealize Orchestrator server ")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-01-11T04:46:40.806Z")

public class VroRemoteInventoryItem   {
  @JsonProperty("href")
  private String href = null;

  @JsonProperty("attributes")
  private List<WsAttribute> attributes = null;

  @JsonProperty("relations")
  private Relations relations = null;

  public VroRemoteInventoryItem href(String href) {
    this.href = href;
    return this;
  }

   /**
   * Get href
   * @return href
  **/
  @ApiModelProperty(value = "")


  public String getHref() {
    return href;
  }

  public void setHref(String href) {
    this.href = href;
  }

  public VroRemoteInventoryItem attributes(List<WsAttribute> attributes) {
    this.attributes = attributes;
    return this;
  }

  public VroRemoteInventoryItem addAttributesItem(WsAttribute attributesItem) {
    if (this.attributes == null) {
      this.attributes = new ArrayList<WsAttribute>();
    }
    this.attributes.add(attributesItem);
    return this;
  }

   /**
   * Get attributes
   * @return attributes
  **/
  @ApiModelProperty(value = "")

  @Valid

  public List<WsAttribute> getAttributes() {
    return attributes;
  }

  public void setAttributes(List<WsAttribute> attributes) {
    this.attributes = attributes;
  }

  public VroRemoteInventoryItem relations(Relations relations) {
    this.relations = relations;
    return this;
  }

   /**
   * Get relations
   * @return relations
  **/
  @ApiModelProperty(value = "")

  @Valid

  public Relations getRelations() {
    return relations;
  }

  public void setRelations(Relations relations) {
    this.relations = relations;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VroRemoteInventoryItem vroRemoteInventoryItem = (VroRemoteInventoryItem) o;
    return Objects.equals(this.href, vroRemoteInventoryItem.href) &&
        Objects.equals(this.attributes, vroRemoteInventoryItem.attributes) &&
        Objects.equals(this.relations, vroRemoteInventoryItem.relations);
  }

  @Override
  public int hashCode() {
    return Objects.hash(href, attributes, relations);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VroRemoteInventoryItem {\n");
    
    sb.append("    href: ").append(toIndentedString(href)).append("\n");
    sb.append("    attributes: ").append(toIndentedString(attributes)).append("\n");
    sb.append("    relations: ").append(toIndentedString(relations)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

