package com.vmware.vcloud.rest.openapi.model;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Meta information about a workflow on a vRealize Orchestrator server 
 */
@ApiModel(description = "Meta information about a workflow on a vRealize Orchestrator server ")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-01-11T04:46:40.806Z")

public class VroRemoteWorkflowItem   {
  @JsonProperty("name")
  private String name = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("categoryName")
  private String categoryName = null;

  @JsonProperty("canExecute")
  private Boolean canExecute = null;

  @JsonProperty("id")
  private String id = null;

  @JsonProperty("vroServerId")
  private String vroServerId = null;

  public VroRemoteWorkflowItem name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @ApiModelProperty(value = "")


  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public VroRemoteWorkflowItem description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @ApiModelProperty(value = "")


  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public VroRemoteWorkflowItem categoryName(String categoryName) {
    this.categoryName = categoryName;
    return this;
  }

   /**
   * Get categoryName
   * @return categoryName
  **/
  @ApiModelProperty(value = "")


  public String getCategoryName() {
    return categoryName;
  }

  public void setCategoryName(String categoryName) {
    this.categoryName = categoryName;
  }

  public VroRemoteWorkflowItem canExecute(Boolean canExecute) {
    this.canExecute = canExecute;
    return this;
  }

   /**
   * Get canExecute
   * @return canExecute
  **/
  @ApiModelProperty(value = "")


  public Boolean getCanExecute() {
    return canExecute;
  }

  public void setCanExecute(Boolean canExecute) {
    this.canExecute = canExecute;
  }

  public VroRemoteWorkflowItem id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(value = "")


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public VroRemoteWorkflowItem vroServerId(String vroServerId) {
    this.vroServerId = vroServerId;
    return this;
  }

   /**
   * Get vroServerId
   * @return vroServerId
  **/
  @ApiModelProperty(value = "")


  public String getVroServerId() {
    return vroServerId;
  }

  public void setVroServerId(String vroServerId) {
    this.vroServerId = vroServerId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    VroRemoteWorkflowItem vroRemoteWorkflowItem = (VroRemoteWorkflowItem) o;
    return Objects.equals(this.name, vroRemoteWorkflowItem.name) &&
        Objects.equals(this.description, vroRemoteWorkflowItem.description) &&
        Objects.equals(this.categoryName, vroRemoteWorkflowItem.categoryName) &&
        Objects.equals(this.canExecute, vroRemoteWorkflowItem.canExecute) &&
        Objects.equals(this.id, vroRemoteWorkflowItem.id) &&
        Objects.equals(this.vroServerId, vroRemoteWorkflowItem.vroServerId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, description, categoryName, canExecute, id, vroServerId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class VroRemoteWorkflowItem {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    categoryName: ").append(toIndentedString(categoryName)).append("\n");
    sb.append("    canExecute: ").append(toIndentedString(canExecute)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    vroServerId: ").append(toIndentedString(vroServerId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

