package com.vmware.vcloud.rest.openapi.model;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.vmware.vcloud.rest.openapi.model.ExecutionState;
import com.vmware.vcloud.rest.openapi.model.Relations;
import com.vmware.vcloud.rest.openapi.model.WsParameter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * WsWorkflowExecution
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-01-11T04:46:40.806Z")

public class WsWorkflowExecution   {
  @JsonProperty("businessState")
  private String businessState = null;

  @JsonProperty("contentException")
  private String contentException = null;

  @JsonProperty("currentItemDisplayName")
  private String currentItemDisplayName = null;

  @JsonProperty("endDate")
  private Date endDate = null;

  @JsonProperty("id")
  private String id = null;

  @JsonProperty("inputParameters")
  private List<WsParameter> inputParameters = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("outputParameters")
  private List<WsParameter> outputParameters = null;

  @JsonProperty("relations")
  private Relations relations = null;

  @JsonProperty("startDate")
  private Date startDate = null;

  @JsonProperty("startedBy")
  private String startedBy = null;

  @JsonProperty("state")
  private ExecutionState state = null;

  public WsWorkflowExecution businessState(String businessState) {
    this.businessState = businessState;
    return this;
  }

   /**
   * Get businessState
   * @return businessState
  **/
  @ApiModelProperty(value = "")


  public String getBusinessState() {
    return businessState;
  }

  public void setBusinessState(String businessState) {
    this.businessState = businessState;
  }

  public WsWorkflowExecution contentException(String contentException) {
    this.contentException = contentException;
    return this;
  }

   /**
   * Get contentException
   * @return contentException
  **/
  @ApiModelProperty(value = "")


  public String getContentException() {
    return contentException;
  }

  public void setContentException(String contentException) {
    this.contentException = contentException;
  }

  public WsWorkflowExecution currentItemDisplayName(String currentItemDisplayName) {
    this.currentItemDisplayName = currentItemDisplayName;
    return this;
  }

   /**
   * Get currentItemDisplayName
   * @return currentItemDisplayName
  **/
  @ApiModelProperty(value = "")


  public String getCurrentItemDisplayName() {
    return currentItemDisplayName;
  }

  public void setCurrentItemDisplayName(String currentItemDisplayName) {
    this.currentItemDisplayName = currentItemDisplayName;
  }

  public WsWorkflowExecution endDate(Date endDate) {
    this.endDate = endDate;
    return this;
  }

   /**
   * Get endDate
   * @return endDate
  **/
  @ApiModelProperty(value = "")

  @Valid

  public Date getEndDate() {
    return endDate;
  }

  public void setEndDate(Date endDate) {
    this.endDate = endDate;
  }

  public WsWorkflowExecution id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(value = "")


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public WsWorkflowExecution inputParameters(List<WsParameter> inputParameters) {
    this.inputParameters = inputParameters;
    return this;
  }

  public WsWorkflowExecution addInputParametersItem(WsParameter inputParametersItem) {
    if (this.inputParameters == null) {
      this.inputParameters = new ArrayList<WsParameter>();
    }
    this.inputParameters.add(inputParametersItem);
    return this;
  }

   /**
   * Get inputParameters
   * @return inputParameters
  **/
  @ApiModelProperty(value = "")

  @Valid

  public List<WsParameter> getInputParameters() {
    return inputParameters;
  }

  public void setInputParameters(List<WsParameter> inputParameters) {
    this.inputParameters = inputParameters;
  }

  public WsWorkflowExecution name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @ApiModelProperty(value = "")


  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public WsWorkflowExecution outputParameters(List<WsParameter> outputParameters) {
    this.outputParameters = outputParameters;
    return this;
  }

  public WsWorkflowExecution addOutputParametersItem(WsParameter outputParametersItem) {
    if (this.outputParameters == null) {
      this.outputParameters = new ArrayList<WsParameter>();
    }
    this.outputParameters.add(outputParametersItem);
    return this;
  }

   /**
   * Get outputParameters
   * @return outputParameters
  **/
  @ApiModelProperty(value = "")

  @Valid

  public List<WsParameter> getOutputParameters() {
    return outputParameters;
  }

  public void setOutputParameters(List<WsParameter> outputParameters) {
    this.outputParameters = outputParameters;
  }

  public WsWorkflowExecution relations(Relations relations) {
    this.relations = relations;
    return this;
  }

   /**
   * Get relations
   * @return relations
  **/
  @ApiModelProperty(value = "")

  @Valid

  public Relations getRelations() {
    return relations;
  }

  public void setRelations(Relations relations) {
    this.relations = relations;
  }

  public WsWorkflowExecution startDate(Date startDate) {
    this.startDate = startDate;
    return this;
  }

   /**
   * Get startDate
   * @return startDate
  **/
  @ApiModelProperty(value = "")

  @Valid

  public Date getStartDate() {
    return startDate;
  }

  public void setStartDate(Date startDate) {
    this.startDate = startDate;
  }

  public WsWorkflowExecution startedBy(String startedBy) {
    this.startedBy = startedBy;
    return this;
  }

   /**
   * Get startedBy
   * @return startedBy
  **/
  @ApiModelProperty(value = "")


  public String getStartedBy() {
    return startedBy;
  }

  public void setStartedBy(String startedBy) {
    this.startedBy = startedBy;
  }

  public WsWorkflowExecution state(ExecutionState state) {
    this.state = state;
    return this;
  }

   /**
   * Get state
   * @return state
  **/
  @ApiModelProperty(value = "")

  @Valid

  public ExecutionState getState() {
    return state;
  }

  public void setState(ExecutionState state) {
    this.state = state;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WsWorkflowExecution wsWorkflowExecution = (WsWorkflowExecution) o;
    return Objects.equals(this.businessState, wsWorkflowExecution.businessState) &&
        Objects.equals(this.contentException, wsWorkflowExecution.contentException) &&
        Objects.equals(this.currentItemDisplayName, wsWorkflowExecution.currentItemDisplayName) &&
        Objects.equals(this.endDate, wsWorkflowExecution.endDate) &&
        Objects.equals(this.id, wsWorkflowExecution.id) &&
        Objects.equals(this.inputParameters, wsWorkflowExecution.inputParameters) &&
        Objects.equals(this.name, wsWorkflowExecution.name) &&
        Objects.equals(this.outputParameters, wsWorkflowExecution.outputParameters) &&
        Objects.equals(this.relations, wsWorkflowExecution.relations) &&
        Objects.equals(this.startDate, wsWorkflowExecution.startDate) &&
        Objects.equals(this.startedBy, wsWorkflowExecution.startedBy) &&
        Objects.equals(this.state, wsWorkflowExecution.state);
  }

  @Override
  public int hashCode() {
    return Objects.hash(businessState, contentException, currentItemDisplayName, endDate, id, inputParameters, name, outputParameters, relations, startDate, startedBy, state);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WsWorkflowExecution {\n");
    
    sb.append("    businessState: ").append(toIndentedString(businessState)).append("\n");
    sb.append("    contentException: ").append(toIndentedString(contentException)).append("\n");
    sb.append("    currentItemDisplayName: ").append(toIndentedString(currentItemDisplayName)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    inputParameters: ").append(toIndentedString(inputParameters)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    outputParameters: ").append(toIndentedString(outputParameters)).append("\n");
    sb.append("    relations: ").append(toIndentedString(relations)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    startedBy: ").append(toIndentedString(startedBy)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

