/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.rest.openapi.api;

import com.vmware.vcloud.rest.openapi.model.EntityReference;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/")
@Api(value="/", description="")
public interface UiPluginTenantsApi {
    @GET
    @Path(value="/extensions/ui/{id}/tenants")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieves list of tenants for whom the plugin is explicitly published", tags={"uiPluginTenants"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=EntityReference.class, responseContainer="List")})
    public List<EntityReference> getUiPluginTenants(@PathParam(value="id") String var1);

    @POST
    @Path(value="/extensions/ui/{id}/tenants/publish")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Publishes the UI plugin to the specified tenants", tags={"uiPluginTenants"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=EntityReference.class, responseContainer="List")})
    public List<EntityReference> postUiPluginPublish(@Valid List<EntityReference> var1, @PathParam(value="id") String var2);

    @POST
    @Path(value="/extensions/ui/{id}/tenants/publishAll")
    @Produces(value={"application/json"})
    @ApiOperation(value="Publishes the UI plugin to all tenants", tags={"uiPluginTenants"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=EntityReference.class, responseContainer="List")})
    public List<EntityReference> postUiPluginPublishAll(@PathParam(value="id") String var1);

    @POST
    @Path(value="/extensions/ui/{id}/tenants/unpublish")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Revokes publication of the UI plugin to the specified tenants", tags={"uiPluginTenants"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=EntityReference.class, responseContainer="List")})
    public List<EntityReference> postUiPluginUnpublish(@Valid List<EntityReference> var1, @PathParam(value="id") String var2);

    @POST
    @Path(value="/extensions/ui/{id}/tenants/unpublishAll")
    @Produces(value={"application/json"})
    @ApiOperation(value="Unpublishes the UI plugin from all tenants", tags={"uiPluginTenants"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=EntityReference.class, responseContainer="List")})
    public List<EntityReference> postUiPluginUnpublishAll(@PathParam(value="id") String var1);
}

