/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.rest.openapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vmware.vcloud.rest.openapi.model.UiBrandingLink;
import com.vmware.vcloud.rest.openapi.model.UiTheme;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;

@ApiModel(description="A branding object with the portal name, portal color, selected theme and custom URLs. ")
public class UiBranding {
    @JsonProperty(value="portalName")
    private String portalName = null;
    @JsonProperty(value="portalColor")
    private String portalColor = null;
    @JsonProperty(value="selectedTheme")
    private UiTheme selectedTheme = null;
    @JsonProperty(value="customLinks")
    private List<UiBrandingLink> customLinks = null;

    public UiBranding portalName(String portalName) {
        this.portalName = portalName;
        return this;
    }

    @ApiModelProperty(value="")
    public String getPortalName() {
        return this.portalName;
    }

    public void setPortalName(String portalName) {
        this.portalName = portalName;
    }

    public UiBranding portalColor(String portalColor) {
        this.portalColor = portalColor;
        return this;
    }

    @ApiModelProperty(value="A custom color defined by the administrator and used to theme the site. The color should be in rgb hex color format such as \"FFFFFF\" all capitalized. Can be set to an empty string to use the selected theme's default colors. ")
    public String getPortalColor() {
        return this.portalColor;
    }

    public void setPortalColor(String portalColor) {
        this.portalColor = portalColor;
    }

    public UiBranding selectedTheme(UiTheme selectedTheme) {
        this.selectedTheme = selectedTheme;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public UiTheme getSelectedTheme() {
        return this.selectedTheme;
    }

    public void setSelectedTheme(UiTheme selectedTheme) {
        this.selectedTheme = selectedTheme;
    }

    public UiBranding customLinks(List<UiBrandingLink> customLinks) {
        this.customLinks = customLinks;
        return this;
    }

    public UiBranding addCustomLinksItem(UiBrandingLink customLinksItem) {
        if (this.customLinks == null) {
            this.customLinks = new ArrayList<UiBrandingLink>();
        }
        this.customLinks.add(customLinksItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public List<UiBrandingLink> getCustomLinks() {
        return this.customLinks;
    }

    public void setCustomLinks(List<UiBrandingLink> customLinks) {
        this.customLinks = customLinks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UiBranding uiBranding = (UiBranding)o;
        return Objects.equals(this.portalName, uiBranding.portalName) && Objects.equals(this.portalColor, uiBranding.portalColor) && Objects.equals(this.selectedTheme, uiBranding.selectedTheme) && Objects.equals(this.customLinks, uiBranding.customLinks);
    }

    public int hashCode() {
        return Objects.hash(this.portalName, this.portalColor, this.selectedTheme, this.customLinks);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UiBranding {\n");
        sb.append("    portalName: ").append(this.toIndentedString(this.portalName)).append("\n");
        sb.append("    portalColor: ").append(this.toIndentedString(this.portalColor)).append("\n");
        sb.append("    selectedTheme: ").append(this.toIndentedString(this.selectedTheme)).append("\n");
        sb.append("    customLinks: ").append(this.toIndentedString(this.customLinks)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

