package com.vmware.vcloud.rest.openapi.model;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * CreateCustomEntityTypeAction
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-01-18T01:56:01.184Z")

public class CreateCustomEntityTypeAction   {
  @JsonProperty("workflowId")
  private String workflowId = null;

  @JsonProperty("workflowInputParameter")
  private String workflowInputParameter = null;

  public CreateCustomEntityTypeAction workflowId(String workflowId) {
    this.workflowId = workflowId;
    return this;
  }

   /**
   * uuid of workflow. 
   * @return workflowId
  **/
  @ApiModelProperty(required = true, value = "uuid of workflow. ")
  @NotNull


  public String getWorkflowId() {
    return workflowId;
  }

  public void setWorkflowId(String workflowId) {
    this.workflowId = workflowId;
  }

  public CreateCustomEntityTypeAction workflowInputParameter(String workflowInputParameter) {
    this.workflowInputParameter = workflowInputParameter;
    return this;
  }

   /**
   * Name of input parameter of given workflow to which this custom entity type should be mapped. 
   * @return workflowInputParameter
  **/
  @ApiModelProperty(required = true, value = "Name of input parameter of given workflow to which this custom entity type should be mapped. ")
  @NotNull


  public String getWorkflowInputParameter() {
    return workflowInputParameter;
  }

  public void setWorkflowInputParameter(String workflowInputParameter) {
    this.workflowInputParameter = workflowInputParameter;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateCustomEntityTypeAction createCustomEntityTypeAction = (CreateCustomEntityTypeAction) o;
    return Objects.equals(this.workflowId, createCustomEntityTypeAction.workflowId) &&
        Objects.equals(this.workflowInputParameter, createCustomEntityTypeAction.workflowInputParameter);
  }

  @Override
  public int hashCode() {
    return Objects.hash(workflowId, workflowInputParameter);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateCustomEntityTypeAction {\n");
    
    sb.append("    workflowId: ").append(toIndentedString(workflowId)).append("\n");
    sb.append("    workflowInputParameter: ").append(toIndentedString(workflowInputParameter)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

