package com.vmware.vcloud.rest.openapi.model;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * CustomEntityType
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-01-18T01:56:01.184Z")

public class CustomEntityType   {
  @JsonProperty("id")
  private String id = null;

  @JsonProperty("vroId")
  private String vroId = null;

  @JsonProperty("vroDynamicType")
  private String vroDynamicType = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("nss")
  private String nss = null;

  @JsonProperty("description")
  private String description = "";

  public CustomEntityType id(String id) {
    this.id = id;
    return this;
  }

   /**
   * UUID for custom entity type. This is immutable. 
   * @return id
  **/
  @ApiModelProperty(value = "UUID for custom entity type. This is immutable. ")


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public CustomEntityType vroId(String vroId) {
    this.vroId = vroId;
    return this;
  }

   /**
   * Get vroId
   * @return vroId
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull


  public String getVroId() {
    return vroId;
  }

  public void setVroId(String vroId) {
    this.vroId = vroId;
  }

  public CustomEntityType vroDynamicType(String vroDynamicType) {
    this.vroDynamicType = vroDynamicType;
    return this;
  }

   /**
   * This refers to VRO's dynamic type. 
   * @return vroDynamicType
  **/
  @ApiModelProperty(required = true, value = "This refers to VRO's dynamic type. ")
  @NotNull


  public String getVroDynamicType() {
    return vroDynamicType;
  }

  public void setVroDynamicType(String vroDynamicType) {
    this.vroDynamicType = vroDynamicType;
  }

  public CustomEntityType name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Display name. 
   * @return name
  **/
  @ApiModelProperty(required = true, value = "Display name. ")
  @NotNull


  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public CustomEntityType nss(String nss) {
    this.nss = nss;
    return this;
  }

   /**
   * This refers to a unique namespace specific string. 
   * @return nss
  **/
  @ApiModelProperty(required = true, value = "This refers to a unique namespace specific string. ")
  @NotNull


  public String getNss() {
    return nss;
  }

  public void setNss(String nss) {
    this.nss = nss;
  }

  public CustomEntityType description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @ApiModelProperty(value = "")


  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CustomEntityType customEntityType = (CustomEntityType) o;
    return Objects.equals(this.id, customEntityType.id) &&
        Objects.equals(this.vroId, customEntityType.vroId) &&
        Objects.equals(this.vroDynamicType, customEntityType.vroDynamicType) &&
        Objects.equals(this.name, customEntityType.name) &&
        Objects.equals(this.nss, customEntityType.nss) &&
        Objects.equals(this.description, customEntityType.description);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, vroId, vroDynamicType, name, nss, description);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CustomEntityType {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    vroId: ").append(toIndentedString(vroId)).append("\n");
    sb.append("    vroDynamicType: ").append(toIndentedString(vroDynamicType)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    nss: ").append(toIndentedString(nss)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

