package com.vmware.vcloud.rest.openapi.model;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Details about a query that was executed. 
 */
@ApiModel(description = "Details about a query that was executed. ")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-01-18T01:56:01.184Z")

public class QueryDetails   {
  @JsonProperty("filter")
  private String filter = null;

  @JsonProperty("sortAsc")
  private String sortAsc = null;

  @JsonProperty("sortDesc")
  private String sortDesc = null;

  @JsonProperty("page")
  private Integer page = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  public QueryDetails filter(String filter) {
    this.filter = filter;
    return this;
  }

   /**
   * The filter used for this query.  FIQL format.
   * @return filter
  **/
  @ApiModelProperty(value = "The filter used for this query.  FIQL format.")


  public String getFilter() {
    return filter;
  }

  public void setFilter(String filter) {
    this.filter = filter;
  }

  public QueryDetails sortAsc(String sortAsc) {
    this.sortAsc = sortAsc;
    return this;
  }

   /**
   * Field used for ascending sort.
   * @return sortAsc
  **/
  @ApiModelProperty(value = "Field used for ascending sort.")


  public String getSortAsc() {
    return sortAsc;
  }

  public void setSortAsc(String sortAsc) {
    this.sortAsc = sortAsc;
  }

  public QueryDetails sortDesc(String sortDesc) {
    this.sortDesc = sortDesc;
    return this;
  }

   /**
   * Field used for descending sort.
   * @return sortDesc
  **/
  @ApiModelProperty(value = "Field used for descending sort.")


  public String getSortDesc() {
    return sortDesc;
  }

  public void setSortDesc(String sortDesc) {
    this.sortDesc = sortDesc;
  }

  public QueryDetails page(Integer page) {
    this.page = page;
    return this;
  }

   /**
   * The page that was fetched, zero-indexed.
   * @return page
  **/
  @ApiModelProperty(value = "The page that was fetched, zero-indexed.")


  public Integer getPage() {
    return page;
  }

  public void setPage(Integer page) {
    this.page = page;
  }

  public QueryDetails pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * Result count per page that was fetched.
   * @return pageSize
  **/
  @ApiModelProperty(value = "Result count per page that was fetched.")


  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    QueryDetails queryDetails = (QueryDetails) o;
    return Objects.equals(this.filter, queryDetails.filter) &&
        Objects.equals(this.sortAsc, queryDetails.sortAsc) &&
        Objects.equals(this.sortDesc, queryDetails.sortDesc) &&
        Objects.equals(this.page, queryDetails.page) &&
        Objects.equals(this.pageSize, queryDetails.pageSize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(filter, sortAsc, sortDesc, page, pageSize);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class QueryDetails {\n");
    
    sb.append("    filter: ").append(toIndentedString(filter)).append("\n");
    sb.append("    sortAsc: ").append(toIndentedString(sortAsc)).append("\n");
    sb.append("    sortDesc: ").append(toIndentedString(sortDesc)).append("\n");
    sb.append("    page: ").append(toIndentedString(page)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

