package com.vmware.vcloud.rest.openapi.model;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * Service
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-01-18T01:56:01.184Z")

public class Service   {
  @JsonProperty("name")
  private String name = null;

  @JsonProperty("description")
  private String description = "";

  @JsonProperty("iconMimeType")
  private String iconMimeType = null;

  @JsonProperty("iconData")
  private String iconData = null;

  @JsonProperty("id")
  private String id = null;

  @JsonProperty("serviceItems")
  private List<Object> serviceItems = null;

  public Service name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Get name
   * @return name
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull


  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Service description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @ApiModelProperty(value = "")


  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Service iconMimeType(String iconMimeType) {
    this.iconMimeType = iconMimeType;
    return this;
  }

   /**
   * Get iconMimeType
   * @return iconMimeType
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull


  public String getIconMimeType() {
    return iconMimeType;
  }

  public void setIconMimeType(String iconMimeType) {
    this.iconMimeType = iconMimeType;
  }

  public Service iconData(String iconData) {
    this.iconData = iconData;
    return this;
  }

   /**
   * Get iconData
   * @return iconData
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull


  public String getIconData() {
    return iconData;
  }

  public void setIconData(String iconData) {
    this.iconData = iconData;
  }

  public Service id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(value = "")


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Service serviceItems(List<Object> serviceItems) {
    this.serviceItems = serviceItems;
    return this;
  }

  public Service addServiceItemsItem(Object serviceItemsItem) {
    if (this.serviceItems == null) {
      this.serviceItems = new ArrayList<Object>();
    }
    this.serviceItems.add(serviceItemsItem);
    return this;
  }

   /**
   * Get serviceItems
   * @return serviceItems
  **/
  @ApiModelProperty(value = "")


  public List<Object> getServiceItems() {
    return serviceItems;
  }

  public void setServiceItems(List<Object> serviceItems) {
    this.serviceItems = serviceItems;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Service service = (Service) o;
    return Objects.equals(this.name, service.name) &&
        Objects.equals(this.description, service.description) &&
        Objects.equals(this.iconMimeType, service.iconMimeType) &&
        Objects.equals(this.iconData, service.iconData) &&
        Objects.equals(this.id, service.id) &&
        Objects.equals(this.serviceItems, service.serviceItems);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, description, iconMimeType, iconData, id, serviceItems);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Service {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    iconMimeType: ").append(toIndentedString(iconMimeType)).append("\n");
    sb.append("    iconData: ").append(toIndentedString(iconData)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    serviceItems: ").append(toIndentedString(serviceItems)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

