package com.vmware.vcloud.rest.openapi.model;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.vmware.vcloud.rest.openapi.model.Chooser;
import com.vmware.vcloud.rest.openapi.model.Decorator;
import com.vmware.vcloud.rest.openapi.model.DropDown;
import com.vmware.vcloud.rest.openapi.model.MultiLine;
import com.vmware.vcloud.rest.openapi.model.RefreshOnChange;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * SupportedDecorators
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-01-18T01:56:01.184Z")

public class SupportedDecorators   {
  @JsonProperty("decorator")
  private Decorator decorator = null;

  @JsonProperty("refreshOnChange")
  private RefreshOnChange refreshOnChange = null;

  @JsonProperty("multiLine")
  private MultiLine multiLine = null;

  @JsonProperty("chooser")
  private Chooser chooser = null;

  @JsonProperty("dropDown")
  private DropDown dropDown = null;

  public SupportedDecorators decorator(Decorator decorator) {
    this.decorator = decorator;
    return this;
  }

   /**
   * Get decorator
   * @return decorator
  **/
  @ApiModelProperty(value = "")

  @Valid

  public Decorator getDecorator() {
    return decorator;
  }

  public void setDecorator(Decorator decorator) {
    this.decorator = decorator;
  }

  public SupportedDecorators refreshOnChange(RefreshOnChange refreshOnChange) {
    this.refreshOnChange = refreshOnChange;
    return this;
  }

   /**
   * Get refreshOnChange
   * @return refreshOnChange
  **/
  @ApiModelProperty(value = "")

  @Valid

  public RefreshOnChange getRefreshOnChange() {
    return refreshOnChange;
  }

  public void setRefreshOnChange(RefreshOnChange refreshOnChange) {
    this.refreshOnChange = refreshOnChange;
  }

  public SupportedDecorators multiLine(MultiLine multiLine) {
    this.multiLine = multiLine;
    return this;
  }

   /**
   * Get multiLine
   * @return multiLine
  **/
  @ApiModelProperty(value = "")

  @Valid

  public MultiLine getMultiLine() {
    return multiLine;
  }

  public void setMultiLine(MultiLine multiLine) {
    this.multiLine = multiLine;
  }

  public SupportedDecorators chooser(Chooser chooser) {
    this.chooser = chooser;
    return this;
  }

   /**
   * Get chooser
   * @return chooser
  **/
  @ApiModelProperty(value = "")

  @Valid

  public Chooser getChooser() {
    return chooser;
  }

  public void setChooser(Chooser chooser) {
    this.chooser = chooser;
  }

  public SupportedDecorators dropDown(DropDown dropDown) {
    this.dropDown = dropDown;
    return this;
  }

   /**
   * Get dropDown
   * @return dropDown
  **/
  @ApiModelProperty(value = "")

  @Valid

  public DropDown getDropDown() {
    return dropDown;
  }

  public void setDropDown(DropDown dropDown) {
    this.dropDown = dropDown;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SupportedDecorators supportedDecorators = (SupportedDecorators) o;
    return Objects.equals(this.decorator, supportedDecorators.decorator) &&
        Objects.equals(this.refreshOnChange, supportedDecorators.refreshOnChange) &&
        Objects.equals(this.multiLine, supportedDecorators.multiLine) &&
        Objects.equals(this.chooser, supportedDecorators.chooser) &&
        Objects.equals(this.dropDown, supportedDecorators.dropDown);
  }

  @Override
  public int hashCode() {
    return Objects.hash(decorator, refreshOnChange, multiLine, chooser, dropDown);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SupportedDecorators {\n");
    
    sb.append("    decorator: ").append(toIndentedString(decorator)).append("\n");
    sb.append("    refreshOnChange: ").append(toIndentedString(refreshOnChange)).append("\n");
    sb.append("    multiLine: ").append(toIndentedString(multiLine)).append("\n");
    sb.append("    chooser: ").append(toIndentedString(chooser)).append("\n");
    sb.append("    dropDown: ").append(toIndentedString(dropDown)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

