package com.vmware.vcloud.rest.openapi.model;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.vmware.vcloud.rest.openapi.model.UiBrandingLink;
import com.vmware.vcloud.rest.openapi.model.UiTheme;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * A branding object with the portal name, portal color, selected theme and custom URLs. 
 */
@ApiModel(description = "A branding object with the portal name, portal color, selected theme and custom URLs. ")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-01-18T01:56:01.184Z")

public class UiBranding   {
  @JsonProperty("portalName")
  private String portalName = null;

  @JsonProperty("portalColor")
  private String portalColor = null;

  @JsonProperty("selectedTheme")
  private UiTheme selectedTheme = null;

  @JsonProperty("customLinks")
  private List<UiBrandingLink> customLinks = null;

  public UiBranding portalName(String portalName) {
    this.portalName = portalName;
    return this;
  }

   /**
   * Get portalName
   * @return portalName
  **/
  @ApiModelProperty(value = "")


  public String getPortalName() {
    return portalName;
  }

  public void setPortalName(String portalName) {
    this.portalName = portalName;
  }

  public UiBranding portalColor(String portalColor) {
    this.portalColor = portalColor;
    return this;
  }

   /**
   * A custom color defined by the administrator and used to theme the site. The color should be in rgb hex color format such as \"FFFFFF\" all capitalized. Can be set to an empty string to use the selected theme's default colors. 
   * @return portalColor
  **/
  @ApiModelProperty(value = "A custom color defined by the administrator and used to theme the site. The color should be in rgb hex color format such as \"FFFFFF\" all capitalized. Can be set to an empty string to use the selected theme's default colors. ")


  public String getPortalColor() {
    return portalColor;
  }

  public void setPortalColor(String portalColor) {
    this.portalColor = portalColor;
  }

  public UiBranding selectedTheme(UiTheme selectedTheme) {
    this.selectedTheme = selectedTheme;
    return this;
  }

   /**
   * Get selectedTheme
   * @return selectedTheme
  **/
  @ApiModelProperty(value = "")

  @Valid

  public UiTheme getSelectedTheme() {
    return selectedTheme;
  }

  public void setSelectedTheme(UiTheme selectedTheme) {
    this.selectedTheme = selectedTheme;
  }

  public UiBranding customLinks(List<UiBrandingLink> customLinks) {
    this.customLinks = customLinks;
    return this;
  }

  public UiBranding addCustomLinksItem(UiBrandingLink customLinksItem) {
    if (this.customLinks == null) {
      this.customLinks = new ArrayList<UiBrandingLink>();
    }
    this.customLinks.add(customLinksItem);
    return this;
  }

   /**
   * Get customLinks
   * @return customLinks
  **/
  @ApiModelProperty(value = "")

  @Valid

  public List<UiBrandingLink> getCustomLinks() {
    return customLinks;
  }

  public void setCustomLinks(List<UiBrandingLink> customLinks) {
    this.customLinks = customLinks;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UiBranding uiBranding = (UiBranding) o;
    return Objects.equals(this.portalName, uiBranding.portalName) &&
        Objects.equals(this.portalColor, uiBranding.portalColor) &&
        Objects.equals(this.selectedTheme, uiBranding.selectedTheme) &&
        Objects.equals(this.customLinks, uiBranding.customLinks);
  }

  @Override
  public int hashCode() {
    return Objects.hash(portalName, portalColor, selectedTheme, customLinks);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UiBranding {\n");
    
    sb.append("    portalName: ").append(toIndentedString(portalName)).append("\n");
    sb.append("    portalColor: ").append(toIndentedString(portalColor)).append("\n");
    sb.append("    selectedTheme: ").append(toIndentedString(selectedTheme)).append("\n");
    sb.append("    customLinks: ").append(toIndentedString(customLinks)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

