package com.vmware.vcloud.rest.openapi.model;

/*-
 * #%L
 * vcd-api-bindings-java :: vCloud Director REST API bindings
 * %%
 * Copyright (C) 2013 - 2019 VMware
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * #L%
 */

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.vmware.vcloud.rest.openapi.model.UiPluginMetadata;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.Valid;
import javax.validation.constraints.*;

/**
 * UiPluginMetadataResponse
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SpringCodegen", date = "2019-01-18T01:56:01.184Z")

public class UiPluginMetadataResponse   {
  @JsonProperty("pluginName")
  private String pluginName = null;

  @JsonProperty("vendor")
  private String vendor = null;

  @JsonProperty("description")
  private String description = null;

  @JsonProperty("version")
  private String version = null;

  @JsonProperty("license")
  private String license = null;

  @JsonProperty("link")
  private String link = null;

  @JsonProperty("tenant_scoped")
  private Boolean tenantScoped = null;

  @JsonProperty("provider_scoped")
  private Boolean providerScoped = null;

  @JsonProperty("enabled")
  private Boolean enabled = null;

  @JsonProperty("id")
  private String id = null;

  /**
   * Gets or Sets pluginStatus
   */
  public enum PluginStatusEnum {
    UNAVAILABLE("unavailable"),
    
    READY("ready");

    private String value;

    PluginStatusEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static PluginStatusEnum fromValue(String text) {
      for (PluginStatusEnum b : PluginStatusEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

  @JsonProperty("plugin_status")
  private PluginStatusEnum pluginStatus = null;

  @JsonProperty("resourcePath")
  private String resourcePath = null;

  public UiPluginMetadataResponse pluginName(String pluginName) {
    this.pluginName = pluginName;
    return this;
  }

   /**
   * Get pluginName
   * @return pluginName
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull


  public String getPluginName() {
    return pluginName;
  }

  public void setPluginName(String pluginName) {
    this.pluginName = pluginName;
  }

  public UiPluginMetadataResponse vendor(String vendor) {
    this.vendor = vendor;
    return this;
  }

   /**
   * Get vendor
   * @return vendor
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull


  public String getVendor() {
    return vendor;
  }

  public void setVendor(String vendor) {
    this.vendor = vendor;
  }

  public UiPluginMetadataResponse description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Get description
   * @return description
  **/
  @ApiModelProperty(value = "")


  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public UiPluginMetadataResponse version(String version) {
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull


  public String getVersion() {
    return version;
  }

  public void setVersion(String version) {
    this.version = version;
  }

  public UiPluginMetadataResponse license(String license) {
    this.license = license;
    return this;
  }

   /**
   * Get license
   * @return license
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull


  public String getLicense() {
    return license;
  }

  public void setLicense(String license) {
    this.license = license;
  }

  public UiPluginMetadataResponse link(String link) {
    this.link = link;
    return this;
  }

   /**
   * Get link
   * @return link
  **/
  @ApiModelProperty(required = true, value = "")
  @NotNull


  public String getLink() {
    return link;
  }

  public void setLink(String link) {
    this.link = link;
  }

  public UiPluginMetadataResponse tenantScoped(Boolean tenantScoped) {
    this.tenantScoped = tenantScoped;
    return this;
  }

   /**
   * Get tenantScoped
   * @return tenantScoped
  **/
  @ApiModelProperty(value = "")


  public Boolean getTenantScoped() {
    return tenantScoped;
  }

  public void setTenantScoped(Boolean tenantScoped) {
    this.tenantScoped = tenantScoped;
  }

  public UiPluginMetadataResponse providerScoped(Boolean providerScoped) {
    this.providerScoped = providerScoped;
    return this;
  }

   /**
   * Get providerScoped
   * @return providerScoped
  **/
  @ApiModelProperty(value = "")


  public Boolean getProviderScoped() {
    return providerScoped;
  }

  public void setProviderScoped(Boolean providerScoped) {
    this.providerScoped = providerScoped;
  }

  public UiPluginMetadataResponse enabled(Boolean enabled) {
    this.enabled = enabled;
    return this;
  }

   /**
   * Get enabled
   * @return enabled
  **/
  @ApiModelProperty(value = "")


  public Boolean getEnabled() {
    return enabled;
  }

  public void setEnabled(Boolean enabled) {
    this.enabled = enabled;
  }

  public UiPluginMetadataResponse id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(value = "")


  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public UiPluginMetadataResponse pluginStatus(PluginStatusEnum pluginStatus) {
    this.pluginStatus = pluginStatus;
    return this;
  }

   /**
   * Get pluginStatus
   * @return pluginStatus
  **/
  @ApiModelProperty(value = "")


  public PluginStatusEnum getPluginStatus() {
    return pluginStatus;
  }

  public void setPluginStatus(PluginStatusEnum pluginStatus) {
    this.pluginStatus = pluginStatus;
  }

  public UiPluginMetadataResponse resourcePath(String resourcePath) {
    this.resourcePath = resourcePath;
    return this;
  }

   /**
   * Get resourcePath
   * @return resourcePath
  **/
  @ApiModelProperty(value = "")


  public String getResourcePath() {
    return resourcePath;
  }

  public void setResourcePath(String resourcePath) {
    this.resourcePath = resourcePath;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UiPluginMetadataResponse uiPluginMetadataResponse = (UiPluginMetadataResponse) o;
    return Objects.equals(this.pluginName, uiPluginMetadataResponse.pluginName) &&
        Objects.equals(this.vendor, uiPluginMetadataResponse.vendor) &&
        Objects.equals(this.description, uiPluginMetadataResponse.description) &&
        Objects.equals(this.version, uiPluginMetadataResponse.version) &&
        Objects.equals(this.license, uiPluginMetadataResponse.license) &&
        Objects.equals(this.link, uiPluginMetadataResponse.link) &&
        Objects.equals(this.tenantScoped, uiPluginMetadataResponse.tenantScoped) &&
        Objects.equals(this.providerScoped, uiPluginMetadataResponse.providerScoped) &&
        Objects.equals(this.enabled, uiPluginMetadataResponse.enabled) &&
        Objects.equals(this.id, uiPluginMetadataResponse.id) &&
        Objects.equals(this.pluginStatus, uiPluginMetadataResponse.pluginStatus) &&
        Objects.equals(this.resourcePath, uiPluginMetadataResponse.resourcePath);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pluginName, vendor, description, version, license, link, tenantScoped, providerScoped, enabled, id, pluginStatus, resourcePath);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UiPluginMetadataResponse {\n");
    
    sb.append("    pluginName: ").append(toIndentedString(pluginName)).append("\n");
    sb.append("    vendor: ").append(toIndentedString(vendor)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    license: ").append(toIndentedString(license)).append("\n");
    sb.append("    link: ").append(toIndentedString(link)).append("\n");
    sb.append("    tenantScoped: ").append(toIndentedString(tenantScoped)).append("\n");
    sb.append("    providerScoped: ").append(toIndentedString(providerScoped)).append("\n");
    sb.append("    enabled: ").append(toIndentedString(enabled)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    pluginStatus: ").append(toIndentedString(pluginStatus)).append("\n");
    sb.append("    resourcePath: ").append(toIndentedString(resourcePath)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

