/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.rest.openapi.api;

import com.vmware.vcloud.rest.openapi.model.UiBranding;
import com.vmware.vcloud.rest.openapi.model.UiTheme;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;

@Path(value="/")
@Api(value="/", description="")
public interface BrandingApi {
    @DELETE
    @Path(value="/branding/logo")
    @ApiOperation(value="Delete system level logo", tags={"branding"})
    @ApiResponses(value={@ApiResponse(code=204, message="No Content")})
    public void deleteSystemLogo();

    @GET
    @Path(value="/branding/themes")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a list of themes", tags={"branding"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=UiTheme.class, responseContainer="List")})
    public List<UiTheme> getBrandingThemes();

    @GET
    @Path(value="/branding")
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the system level branding", tags={"branding"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=UiBranding.class)})
    public UiBranding getSystemBranding();

    @GET
    @Path(value="/branding/logo")
    @Produces(value={"image/png", "image/jpeg", "image/svg+xml"})
    @ApiOperation(value="Gets the system level logo", tags={"branding"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=byte[].class)})
    public byte[] getSystemLogo();

    @PUT
    @Path(value="/branding")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Sets the system level branding", tags={"branding"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=UiBranding.class)})
    public UiBranding putSystemBranding(@Valid UiBranding var1);

    @PUT
    @Path(value="/branding/logo")
    @Consumes(value={"image/png", "image/jpeg", "image/svg+xml"})
    @ApiOperation(value="Sets the system level logo", tags={"branding"})
    @ApiResponses(value={@ApiResponse(code=204, message="No Content"), @ApiResponse(code=415, message="Unsupported Media Type")})
    public void putSystemLogo(@HeaderParam(value="Content-Type") String var1, @Valid byte[] var2);
}

