/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.rest.openapi.api;

import com.vmware.vcloud.rest.openapi.model.EntityReference;
import com.vmware.vcloud.rest.openapi.model.QueryResults;
import com.vmware.vcloud.rest.openapi.model.Service;
import com.vmware.vcloud.rest.openapi.model.ServiceItem;
import com.vmware.vcloud.rest.openapi.model.VroRemoteWorkflowItem;
import com.vmware.vcloud.rest.openapi.model.VroWorkflowServiceItem;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="/")
@Api(value="/", description="")
public interface ServicesApi {
    @POST
    @Path(value="/serviceItem")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Adds service item", tags={"services"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ServiceItem.class, responseContainer="List")})
    public List<ServiceItem> addServiceItems(@Valid List<ServiceItem> var1);

    @POST
    @Path(value="/serviceLibrary")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Creates a new service", tags={"services"})
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=Service.class)})
    public Service createService(@Valid Service var1);

    @DELETE
    @Path(value="/serviceLibrary/{id}")
    @ApiOperation(value="Delete specified service", tags={"services"})
    @ApiResponses(value={@ApiResponse(code=204, message="No Content")})
    public void deleteService(@PathParam(value="id") String var1);

    @DELETE
    @Path(value="/serviceItem/{id}")
    @ApiOperation(value="Deletes specified service item", tags={"services"})
    @ApiResponses(value={@ApiResponse(code=204, message="No Content")})
    public void deleteServiceItem(@PathParam(value="id") String var1);

    @GET
    @Path(value="/serviceLibrary/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get specified service", tags={"services"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Service.class), @ApiResponse(code=404, message="Not Found")})
    public Service getService(@PathParam(value="id") String var1);

    @GET
    @Path(value="/serviceItem/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get the specified item", tags={"services"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ServiceItem.class), @ApiResponse(code=404, message="Not Found")})
    public ServiceItem getServiceItem(@PathParam(value="id") String var1);

    @GET
    @Path(value="/serviceItem/{id}/tenants")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieves list of tenants for whom the service item is explicitly published", tags={"services"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=EntityReference.class, responseContainer="List")})
    public List<EntityReference> getServiceItemTenants(@PathParam(value="id") String var1);

    @GET
    @Path(value="/serviceLibrary/{id}/workflows")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all workflow items in this service", tags={"services"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=VroWorkflowServiceItem.class, responseContainer="List")})
    public List<VroWorkflowServiceItem> getWorkflowServiceItems(@PathParam(value="id") String var1);

    @POST
    @Path(value="/serviceLibrary/{id}/workflows")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Add VRO remote workflows to this service", tags={"services"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ServiceItem.class, responseContainer="List"), @ApiResponse(code=404, message="Not Found")})
    public List<ServiceItem> importVroWorkflows(@Valid List<VroRemoteWorkflowItem> var1, @PathParam(value="id") String var2);

    @POST
    @Path(value="/serviceItem/{id}/tenants/publish")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Publishes the service item to the specified tenants", tags={"services"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=EntityReference.class, responseContainer="List")})
    public List<EntityReference> postServiceItemPublish(@Valid List<EntityReference> var1, @PathParam(value="id") String var2);

    @POST
    @Path(value="/serviceItem/{id}/tenants/publishAll")
    @Produces(value={"application/json"})
    @ApiOperation(value="Publishes the service item to all tenants", tags={"services"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=EntityReference.class, responseContainer="List")})
    public List<EntityReference> postServiceItemPublishAll(@PathParam(value="id") String var1);

    @POST
    @Path(value="/serviceItem/{id}/tenants/unpublish")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Revokes publication of the service item to the specified tenants", tags={"services"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=EntityReference.class, responseContainer="List")})
    public List<EntityReference> postServiceItemUnpublish(@Valid List<EntityReference> var1, @PathParam(value="id") String var2);

    @POST
    @Path(value="/serviceItem/{id}/tenants/unpublishAll")
    @Produces(value={"application/json"})
    @ApiOperation(value="Unpublishes the service item from all tenants", tags={"services"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=EntityReference.class, responseContainer="List")})
    public List<EntityReference> postServiceItemUnpublishAll(@PathParam(value="id") String var1);

    @GET
    @Path(value="/serviceItem")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all items across all services", tags={"services"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=QueryResults.class)})
    public QueryResults queryServiceItems(@QueryParam(value="page") @NotNull @DefaultValue(value="1") Integer var1, @QueryParam(value="pageSize") @NotNull @DefaultValue(value="10") Integer var2, @QueryParam(value="filter") @DefaultValue(value="") String var3, @QueryParam(value="sortAsc") @DefaultValue(value="") String var4, @QueryParam(value="sortDesc") @DefaultValue(value="") String var5);

    @GET
    @Path(value="/serviceLibrary")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get list of services", tags={"services"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=QueryResults.class)})
    public QueryResults queryServices(@QueryParam(value="page") @NotNull @DefaultValue(value="1") Integer var1, @QueryParam(value="pageSize") @NotNull @DefaultValue(value="10") Integer var2, @QueryParam(value="filter") @DefaultValue(value="") String var3, @QueryParam(value="sortAsc") @DefaultValue(value="") String var4, @QueryParam(value="sortDesc") @DefaultValue(value="") String var5);

    @PUT
    @Path(value="/serviceLibrary/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update specified service", tags={"services"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Service.class)})
    public Service updateService(@Valid Service var1, @PathParam(value="id") String var2);

    @PUT
    @Path(value="/serviceItem/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update specified service item", tags={"services"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ServiceItem.class)})
    public ServiceItem updateServiceItem(@Valid ServiceItem var1, @PathParam(value="id") String var2);
}

