/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.rest.openapi.api;

import com.vmware.vcloud.rest.openapi.model.VROServiceInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.jaxrs.PATCH;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/")
@Api(value="/", description="")
public interface VRealizeOrchestratorApi {
    @GET
    @Path(value="/vro/servers/{id}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieves service specific metadata for a vRealize Orchestrator", tags={"vRealizeOrchestrator"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=VROServiceInfo.class)})
    public VROServiceInfo getRegisteredVRO(@PathParam(value="id") String var1);

    @PATCH
    @Path(value="/vro/servers/{id}")
    @Consumes(value={"application/merge-patch+json", "application/json-patch+json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Updates service specific metadata for a vRealize Orchestrator", tags={"vRealizeOrchestrator"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=VROServiceInfo.class)})
    public VROServiceInfo patchService(@Valid VROServiceInfo var1, @PathParam(value="id") String var2);

    @DELETE
    @Path(value="/vro/servers/{id}")
    @ApiOperation(value="Unregisters a vRealize Orchestrator endpoint from vCloud Director", tags={"vRealizeOrchestrator"})
    @ApiResponses(value={@ApiResponse(code=204, message="No Content")})
    public void unregister(@PathParam(value="id") String var1);

    @PUT
    @Path(value="/vro/servers/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Updates service specific metadata for a vRealize Orchestrator", tags={"vRealizeOrchestrator"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=VROServiceInfo.class)})
    public VROServiceInfo updateService(@Valid VROServiceInfo var1, @PathParam(value="id") String var2);
}

