/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.rest.openapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.vmware.vcloud.rest.openapi.model.QueryDetails;
import com.vmware.vcloud.rest.openapi.model.QueryResult;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;

@ApiModel(description="Base query results, encapsulating page information and the query. ")
public class QueryResults {
    @JsonProperty(value="query")
    private QueryDetails query = null;
    @JsonProperty(value="results")
    private List<QueryResult> results = null;
    @JsonProperty(value="resultTotal")
    private Integer resultTotal = null;
    @JsonProperty(value="pageCount")
    private Integer pageCount = null;

    public QueryResults query(QueryDetails query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public QueryDetails getQuery() {
        return this.query;
    }

    public void setQuery(QueryDetails query) {
        this.query = query;
    }

    public QueryResults results(List<QueryResult> results) {
        this.results = results;
        return this;
    }

    public QueryResults addResultsItem(QueryResult resultsItem) {
        if (this.results == null) {
            this.results = new ArrayList<QueryResult>();
        }
        this.results.add(resultsItem);
        return this;
    }

    @ApiModelProperty(value="The returned objects from this query.")
    @Valid
    public List<QueryResult> getResults() {
        return this.results;
    }

    public void setResults(List<QueryResult> results) {
        this.results = results;
    }

    public QueryResults resultTotal(Integer resultTotal) {
        this.resultTotal = resultTotal;
        return this;
    }

    @ApiModelProperty(value="How many results there are in total (i.e., considering all pages).")
    public Integer getResultTotal() {
        return this.resultTotal;
    }

    public void setResultTotal(Integer resultTotal) {
        this.resultTotal = resultTotal;
    }

    public QueryResults pageCount(Integer pageCount) {
        this.pageCount = pageCount;
        return this;
    }

    @ApiModelProperty(value="How many pages there are in total.")
    public Integer getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(Integer pageCount) {
        this.pageCount = pageCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryResults queryResults = (QueryResults)o;
        return Objects.equals(this.query, queryResults.query) && Objects.equals(this.results, queryResults.results) && Objects.equals(this.resultTotal, queryResults.resultTotal) && Objects.equals(this.pageCount, queryResults.pageCount);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.results, this.resultTotal, this.pageCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QueryResults {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("    resultTotal: ").append(this.toIndentedString(this.resultTotal)).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.pageCount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

