/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.api.rest.client.impl.tasks;

import java.util.Date;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

class TaskTimingInfo {
    private final AtomicReference<Date> earliestKnownStartTime = new AtomicReference();
    private final AtomicReference<Date> earliestKnownEndTime = new AtomicReference();

    TaskTimingInfo() {
    }

    void updateStartTime(Date startTime) {
        if (startTime == null) {
            return;
        }
        Date accumulatedStartTime = this.earliestKnownStartTime.accumulateAndGet(startTime, (currentStartTime, newStartTime) -> currentStartTime == null || newStartTime.before((Date)currentStartTime) ? newStartTime : currentStartTime);
        if (accumulatedStartTime.equals(startTime)) {
            this.earliestKnownEndTime.set(null);
        }
    }

    void updateEndTime(Date endTime) {
        this.earliestKnownEndTime.accumulateAndGet(endTime, (currentEndTime, newEndTime) -> currentEndTime == null ? null : newEndTime);
    }

    Date getEndTime() {
        return this.earliestKnownEndTime.updateAndGet(endTime -> Optional.ofNullable(endTime).orElse(this.earliestKnownStartTime.get()));
    }
}

