/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcloud.api.rest.client;

import com.vmware.vcloud.api.rest.client.ClientCredentials;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.Objects;
import java.util.UUID;
import javax.ws.rs.ProcessingException;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class VcdMultisiteLoginCredentials
implements ClientCredentials {
    public static final String AUTH_TYPE = "Multisite";
    public static final String MULTISITE_BASIC_AUTH_HEADER_TEMPLATE = "{0} {1}:{2} {3}; {4}";
    public static final String MULTISITE_SSO_AUTH_HEADER_TEMPLATE = "{0} {1}:{2} {3}, {4}";
    public static final String MULTISITE_BASIC_AUTH_USERORG_TEMPLATE = "{0}@{1}";
    private static final String SIGNING_STRING_TEMPLATE = "(request-target): {0} {1}\ndate: {2}\ndigest: {3}\ncontent-length: {4}";
    private static final String DIGEST_ALG = "SHA-256";
    private static final String SIGNATURE_ALGORITHM = "SHA256withRSA";
    private final String delegateCredentials;
    private final PrivateKey privateKey;
    private final String authTemplate;
    private final UUID localSiteId;
    private final UUID localOrgId;

    public VcdMultisiteLoginCredentials(UUID localSiteId, UUID localOrgId, String userName, String orgName, String pemEncodedKey) throws IOException {
        this.delegateCredentials = MessageFormat.format(MULTISITE_BASIC_AUTH_USERORG_TEMPLATE, Objects.requireNonNull(userName, "username id is required"), Objects.requireNonNull(orgName, "org name is required"));
        this.privateKey = this.getPrivateKeyFromPemEncoding(Objects.requireNonNull(pemEncodedKey, "private key is required"));
        this.localSiteId = Objects.requireNonNull(localSiteId, "local site id is required");
        this.localOrgId = Objects.requireNonNull(localOrgId, "local org id is required");
        this.authTemplate = MULTISITE_BASIC_AUTH_HEADER_TEMPLATE;
    }

    public VcdMultisiteLoginCredentials(UUID localSiteId, UUID localOrgId, String ssoCredentials, String pemEncodedKey) throws IOException {
        this.delegateCredentials = Objects.requireNonNull(ssoCredentials, "SSO credentials is required");
        this.privateKey = this.getPrivateKeyFromPemEncoding(Objects.requireNonNull(pemEncodedKey, "private key is required"));
        this.localSiteId = Objects.requireNonNull(localSiteId, "local site id is required");
        this.localOrgId = Objects.requireNonNull(localOrgId, "local org id is required");
        this.authTemplate = MULTISITE_SSO_AUTH_HEADER_TEMPLATE;
    }

    @Override
    public String getHeaderName() {
        return "Authorization";
    }

    @Override
    public String getHeaderValue() {
        return AUTH_TYPE;
    }

    @Override
    public boolean supportsSessionless() {
        return true;
    }

    public String createMultisiteAuthorizationHeader(String date, String method, String path, byte[] contentBytes) {
        try {
            String signingString = this.constructSignatureString(date, method, path, contentBytes);
            String signature = this.signMessage(signingString);
            return MessageFormat.format(this.authTemplate, AUTH_TYPE, this.localSiteId, this.localOrgId, signature, this.delegateCredentials);
        }
        catch (Exception e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    private String signMessage(String signingString) throws SignatureException {
        try {
            Signature sig = Signature.getInstance(SIGNATURE_ALGORITHM);
            sig.initSign(this.privateKey);
            sig.update(signingString.getBytes());
            return Base64.getEncoder().encodeToString(sig.sign());
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }

    private String constructSignatureString(String date, String method, String path, byte[] contentBytes) throws NoSuchAlgorithmException, IOException {
        if (contentBytes == null) {
            contentBytes = new byte[]{};
        }
        String digest = this.createDigest(contentBytes);
        int contentLength = contentBytes.length;
        String signingString = MessageFormat.format(SIGNING_STRING_TEMPLATE, method, path, date, digest, contentLength);
        return signingString;
    }

    private String createDigest(byte[] contentBytes) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance(DIGEST_ALG);
        md.update(contentBytes);
        byte[] digestBytes = md.digest();
        return Base64.getEncoder().encodeToString(digestBytes);
    }

    private PrivateKey getPrivateKeyFromPemEncoding(String pemString) throws IOException {
        block37: {
            if (pemString != null) {
                try (StringReader reader = new StringReader(pemString);){
                    PrivateKey privateKey;
                    try (PEMParser pemParser = new PEMParser((Reader)reader);){
                        Object object = pemParser.readObject();
                        if (object instanceof PrivateKeyInfo) {
                            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
                            PrivateKey privateKey2 = converter.getPrivateKey((PrivateKeyInfo)object);
                            return privateKey2;
                        }
                        if (!(object instanceof PEMKeyPair)) break block37;
                        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
                        privateKey = converter.getKeyPair((PEMKeyPair)object).getPrivate();
                    }
                    return privateKey;
                }
            }
        }
        throw new IllegalArgumentException("Supplied key string is not a valid PEM encoded private key");
    }
}

