/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.util.concurrent.RecyclableRateLimiter;
import com.yammer.metrics.core.Counter;
import javax.annotation.Nullable;

public class RecyclableRateLimiterWithMetrics
implements RecyclableRateLimiter {
    private final RecyclableRateLimiter rateLimiter;
    private final Counter permitsGranted;
    private final Counter permitsDenied;
    private final Counter permitsRecycled;

    public RecyclableRateLimiterWithMetrics(RecyclableRateLimiter rateLimiter, @Nullable Counter permitsGrantedCounter, @Nullable Counter permitsDeniedCounter, @Nullable Counter permitsRecycledCounter) {
        this.rateLimiter = rateLimiter;
        this.permitsGranted = permitsGrantedCounter;
        this.permitsDenied = permitsDeniedCounter;
        this.permitsRecycled = permitsRecycledCounter;
    }

    @Override
    public double getRate() {
        return this.rateLimiter.getRate();
    }

    @Override
    public void setRate(double rate) {
        this.rateLimiter.setRate(rate);
    }

    @Override
    public double acquire(int permits) {
        double result = this.rateLimiter.acquire(permits);
        if (this.permitsGranted != null) {
            this.permitsGranted.inc((long)permits);
        }
        return result;
    }

    @Override
    public boolean tryAcquire(int permits) {
        if (this.rateLimiter.tryAcquire(permits)) {
            if (this.permitsGranted != null) {
                this.permitsGranted.inc((long)permits);
            }
            return true;
        }
        if (this.permitsDenied != null) {
            this.permitsDenied.inc((long)permits);
        }
        return false;
    }

    @Override
    public void recyclePermits(int permits) {
        this.rateLimiter.recyclePermits(permits);
        if (this.permitsRecycled != null) {
            this.permitsRecycled.inc((long)permits);
        }
    }

    @Override
    public boolean immediatelyAvailable(int permits) {
        boolean result = this.rateLimiter.immediatelyAvailable(permits);
        if (!result && this.permitsDenied != null) {
            this.permitsDenied.inc((long)permits);
        }
        return result;
    }
}

