/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.collect.ImmutableList;
import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.ReportSourceTagIngesterFormatter;
import com.wavefront.ingester.ReportableEntityDecoder;
import java.util.List;
import wavefront.report.ReportSourceTag;

public class ReportSourceTagDecoder
implements ReportableEntityDecoder<String, ReportSourceTag> {
    public static final String SOURCE_TAG = "@SourceTag";
    public static final String SOURCE_DESCRIPTION = "@SourceDescription";
    private static final AbstractIngesterFormatter<ReportSourceTag> FORMAT = ReportSourceTagIngesterFormatter.newBuilder().whiteSpace().appendCaseSensitiveLiterals(new String[]{"@SourceTag", "@SourceDescription"}).whiteSpace().appendLoopOfKeywords().whiteSpace().appendLoopOfValues().build();

    @Override
    public void decode(String msg, List<ReportSourceTag> out, String customerId) {
        ReportSourceTag tag = FORMAT.drive(msg, "dummy", customerId, null);
        if (out == null) {
            return;
        }
        if ((tag.getAction().equals("add") || tag.getAction().equals("delete")) && tag.getAnnotations().size() > 1) {
            tag.getAnnotations().forEach(x -> out.add(ReportSourceTag.newBuilder(tag).setAnnotations((List<String>)ImmutableList.of((Object)x)).build()));
        } else {
            out.add(tag);
        }
    }
}

