/*
 * Decompiled with CFR 0.152.
 */
package com.yammer.metrics.core;

import com.wavefront.common.EvictingRingBuffer;
import com.wavefront.common.NamedThreadFactory;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricProcessor;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class BurstRateTrackingCounter
extends Counter
implements Metric {
    private static final MetricsRegistry LOCAL_REGISTRY = new MetricsRegistry();
    private static final ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(1, new NamedThreadFactory("burst-tracking-counter"));
    private final Counter delegate;
    private final int granularityMillis;
    private final Histogram burstRateHistogram;
    private long previousCount = 0L;
    private long currentRate = 0L;
    private final EvictingRingBuffer<Long> perPeriodStats;

    public BurstRateTrackingCounter(MetricName metricName, @Nullable MetricsRegistry metricsRegistry, int granularityMillis) {
        this.delegate = (metricsRegistry == null ? Metrics.defaultRegistry() : metricsRegistry).newCounter(metricName);
        this.granularityMillis = granularityMillis;
        this.perPeriodStats = new EvictingRingBuffer<Long>(300000 / granularityMillis, false, 0L);
        this.burstRateHistogram = LOCAL_REGISTRY.newHistogram(BurstRateTrackingCounter.class, metricName.getGroup() + "-max-burst-rate");
        EXECUTOR.scheduleAtFixedRate(() -> {
            long currentCount = this.delegate.count();
            this.currentRate = currentCount - this.previousCount;
            this.burstRateHistogram.update(this.currentRate);
            this.previousCount = currentCount;
            this.perPeriodStats.add(this.currentRate);
        }, granularityMillis, granularityMillis, TimeUnit.MILLISECONDS);
    }

    public Histogram getBurstRateHistogram() {
        return this.burstRateHistogram;
    }

    public long getCurrentRate() {
        return this.currentRate * 1000L / (long)this.granularityMillis;
    }

    public Double getMaxBurstRateAndClear() {
        Double maxValue = this.burstRateHistogram.max() * 1000.0 / (double)this.granularityMillis;
        this.burstRateHistogram.clear();
        return maxValue;
    }

    public String getOneMinutePrintableRate() {
        return BurstRateTrackingCounter.getPrintableRate(this.getOneMinuteCount());
    }

    public String getFiveMinutePrintableRate() {
        return BurstRateTrackingCounter.getPrintableRate(this.getFiveMinuteCount() / 5L);
    }

    public long getOneMinuteCount() {
        return this.perPeriodStats.toList().subList(240000 / this.granularityMillis, 300000 / this.granularityMillis).stream().mapToLong(i -> i).sum();
    }

    public long getFiveMinuteCount() {
        return this.perPeriodStats.toList().stream().mapToLong(i -> i).sum();
    }

    public static String getPrintableRate(long count) {
        return count < 60L && count > 0L ? "<1" : String.valueOf((count + 30L) / 60L);
    }

    public void inc() {
        this.delegate.inc();
    }

    public void inc(long n) {
        this.delegate.inc(n);
    }

    public void dec() {
        this.delegate.dec();
    }

    public void dec(long n) {
        this.delegate.dec(n);
    }

    public long count() {
        return this.delegate.count();
    }

    public void clear() {
        this.delegate.clear();
    }

    public <T> void processWith(MetricProcessor<T> processor, MetricName name, T context) throws Exception {
        this.delegate.processWith(processor, name, context);
    }
}

