/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import wavefront.report.ReportSourceTag;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SourceTag
implements Serializable {
    @JsonProperty
    private String sourceTagLiteral;
    @JsonProperty
    private String action;
    @JsonProperty
    private String source;
    @JsonProperty
    private String description;
    @JsonProperty
    private List<String> annotations;

    private SourceTag() {
    }

    public SourceTag(ReportSourceTag sourceTag) {
        this.sourceTagLiteral = sourceTag.getSourceTagLiteral();
        this.action = sourceTag.getAction();
        this.source = sourceTag.getSource();
        this.description = sourceTag.getDescription();
        this.annotations = new ArrayList<String>(sourceTag.getAnnotations());
    }

    public String getSourceTagLiteral() {
        return this.sourceTagLiteral;
    }

    public String getAction() {
        return this.action;
    }

    public String getSource() {
        return this.source;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getAnnotations() {
        return this.annotations;
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.sourceTagLiteral == null ? 0 : this.sourceTagLiteral.hashCode());
        result = result * 31 + (this.action == null ? 0 : this.action.hashCode());
        result = result * 31 + (this.source == null ? 0 : this.source.hashCode());
        result = result * 31 + (this.description == null ? 0 : this.description.hashCode());
        result = result * 31 + (this.annotations == null ? 0 : this.annotations.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SourceTag other = (SourceTag)obj;
        if (!Objects.equals(this.sourceTagLiteral, other.sourceTagLiteral)) {
            return false;
        }
        if (!Objects.equals(this.action, other.action)) {
            return false;
        }
        if (!Objects.equals(this.source, other.source)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        return Objects.equals(this.annotations, other.annotations);
    }
}

