/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.base.Function;
import com.wavefront.ingester.Ingester;
import com.wavefront.metrics.ExpectedAgentMetric;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.BindException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TcpIngester
extends Ingester {
    private static final Logger logger = Logger.getLogger(TcpIngester.class.getCanonicalName());
    private Counter activeListeners;
    private Counter bindErrors;

    @Deprecated
    public TcpIngester(List<Function<Channel, ChannelHandler>> decoders, ChannelHandler commandHandler, int port) {
        super(decoders, commandHandler, port);
        this.activeListeners = Metrics.newCounter((MetricName)ExpectedAgentMetric.ACTIVE_LISTENERS.metricName);
        this.bindErrors = Metrics.newCounter((MetricName)ExpectedAgentMetric.LISTENERS_BIND_ERRORS.metricName);
    }

    public TcpIngester(ChannelInitializer initializer, int port) {
        super(initializer, port);
        this.activeListeners = Metrics.newCounter((MetricName)ExpectedAgentMetric.ACTIVE_LISTENERS.metricName);
        this.bindErrors = Metrics.newCounter((MetricName)ExpectedAgentMetric.LISTENERS_BIND_ERRORS.metricName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Class<EpollServerSocketChannel> socketChannelClass;
        EpollEventLoopGroup childGroup;
        EpollEventLoopGroup parentGroup;
        this.activeListeners.inc();
        ServerBootstrap b = new ServerBootstrap();
        if (Epoll.isAvailable()) {
            logger.fine("Using native socket transport for port " + this.listeningPort);
            parentGroup = new EpollEventLoopGroup(1);
            childGroup = new EpollEventLoopGroup();
            socketChannelClass = EpollServerSocketChannel.class;
        } else {
            logger.fine("Using NIO socket transport for port " + this.listeningPort);
            parentGroup = new NioEventLoopGroup(1);
            childGroup = new NioEventLoopGroup();
            socketChannelClass = NioServerSocketChannel.class;
        }
        try {
            ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)parentGroup, (EventLoopGroup)childGroup).channel(socketChannelClass)).option(ChannelOption.SO_BACKLOG, (Object)1024)).localAddress(this.listeningPort)).childHandler((ChannelHandler)this.initializer);
            if (this.parentChannelOptions != null) {
                for (Map.Entry entry : this.parentChannelOptions.entrySet()) {
                    b.option((ChannelOption)entry.getKey(), entry.getValue());
                }
            }
            if (this.childChannelOptions != null) {
                for (Map.Entry entry : this.childChannelOptions.entrySet()) {
                    b.childOption((ChannelOption)entry.getKey(), entry.getValue());
                }
            }
            ChannelFuture f = b.bind().sync();
            f.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            parentGroup.shutdownGracefully();
            childGroup.shutdownGracefully();
            logger.info("Listener on port " + this.listeningPort + " shut down");
        }
        catch (Exception e) {
            if (e instanceof BindException) {
                this.bindErrors.inc();
                logger.severe("Unable to start listener - port " + this.listeningPort + " is already in use!");
            } else {
                logger.log(Level.SEVERE, "TcpIngester exception: ", e);
            }
        }
        finally {
            this.activeListeners.dec();
        }
    }
}

