/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.data;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.RateLimiter;
import com.wavefront.api.agent.ValidationConfiguration;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import wavefront.report.Annotation;
import wavefront.report.Histogram;
import wavefront.report.ReportPoint;
import wavefront.report.Span;

public class Validation {
    private static final LoadingCache<String, Counter> ERROR_COUNTERS = Caffeine.newBuilder().build(x -> Metrics.newCounter((MetricName)new MetricName("point", "", x)));
    private static final RateLimiter blockedLoggingRateLimiter = RateLimiter.create((double)1.0);
    private static final Logger log = Logger.getLogger(Validation.class.getCanonicalName());

    public static boolean charactersAreValid(String input) {
        int l = input.length();
        if (l == 0) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            char cur = input.charAt(i);
            if (',' <= cur && cur <= '9' || 'A' <= cur && cur <= 'Z' || 'a' <= cur && cur <= 'z' || cur == '_' || i == 0 && cur == '\u2206' || i == 0 && cur == '\u0394' || i == 0 && cur == '~') continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static boolean annotationKeysAreValid(ReportPoint point) {
        for (String key : point.getAnnotations().keySet()) {
            if (Validation.charactersAreValid(key)) continue;
            return false;
        }
        return true;
    }

    public static void validatePoint(ReportPoint point, @Nullable ValidationConfiguration config) {
        if (config == null) {
            return;
        }
        String host = point.getHost();
        String metric = point.getMetric();
        Object value = point.getValue();
        boolean isHistogram = value instanceof Histogram;
        if (StringUtils.isBlank((String)host)) {
            ((Counter)ERROR_COUNTERS.get((Object)"sourceMissing")).inc();
            throw new IllegalArgumentException("WF-406: Source/host name is required");
        }
        if (host.length() > config.getHostLengthLimit()) {
            ((Counter)ERROR_COUNTERS.get((Object)"sourceTooLong")).inc();
            throw new IllegalArgumentException("WF-407: Source/host name is too long (" + host.length() + " characters, max: " + config.getHostLengthLimit() + "): " + host);
        }
        if (isHistogram) {
            if (metric.length() > config.getHistogramLengthLimit()) {
                ((Counter)ERROR_COUNTERS.get((Object)"histogramNameTooLong")).inc();
                throw new IllegalArgumentException("WF-409: Histogram name is too long (" + metric.length() + " characters, max: " + config.getHistogramLengthLimit() + "): " + metric);
            }
        } else if (metric.length() > config.getMetricLengthLimit()) {
            ((Counter)ERROR_COUNTERS.get((Object)"metricNameTooLong")).inc();
            throw new IllegalArgumentException("WF-408: Metric name is too long (" + metric.length() + " characters, max: " + config.getMetricLengthLimit() + "): " + metric);
        }
        if (!Validation.charactersAreValid(metric)) {
            ((Counter)ERROR_COUNTERS.get((Object)"badchars")).inc();
            throw new IllegalArgumentException("WF-400: Point metric has illegal character(s): " + metric);
        }
        Map<String, String> annotations = point.getAnnotations();
        if (annotations != null) {
            if (annotations.size() > config.getAnnotationsCountLimit()) {
                ((Counter)ERROR_COUNTERS.get((Object)"tooManyPointTags")).inc();
                throw new IllegalArgumentException("WF-410: Too many point tags (" + annotations.size() + ", max " + config.getAnnotationsCountLimit() + "): ");
            }
            for (Map.Entry<String, String> tag : annotations.entrySet()) {
                String tagK = tag.getKey();
                String tagV = tag.getValue();
                if (tagK.length() + tagV.length() >= 255) {
                    ((Counter)ERROR_COUNTERS.get((Object)"pointTagTooLong")).inc();
                    throw new IllegalArgumentException("WF-411: Point tag (key+value) too long (" + (tagK.length() + tagV.length() + 1) + " characters, max: 255): " + tagK + "=" + tagV);
                }
                if (tagK.length() > config.getAnnotationsKeyLengthLimit()) {
                    ((Counter)ERROR_COUNTERS.get((Object)"pointTagKeyTooLong")).inc();
                    throw new IllegalArgumentException("WF-412: Point tag key is too long (" + tagK.length() + " characters, max: " + config.getAnnotationsKeyLengthLimit() + "): " + tagK);
                }
                if (!Validation.charactersAreValid(tagK)) {
                    ((Counter)ERROR_COUNTERS.get((Object)"badchars")).inc();
                    throw new IllegalArgumentException("WF-401: Point tag key has illegal character(s): " + tagK);
                }
                if (tagV.length() <= config.getAnnotationsValueLengthLimit()) continue;
                ((Counter)ERROR_COUNTERS.get((Object)"pointTagValueTooLong")).inc();
                throw new IllegalArgumentException("WF-413: Point tag value is too long (" + tagV.length() + " characters, max: " + config.getAnnotationsValueLengthLimit() + "): " + tagV);
            }
        }
        if (!(value instanceof Double || value instanceof Long || value instanceof Histogram)) {
            throw new IllegalArgumentException("WF-403: Value is not a long/double/histogram object: " + value);
        }
        if (value instanceof Histogram) {
            Histogram histogram = (Histogram)((Object)value);
            if (histogram.getCounts().size() == 0 || histogram.getBins().size() == 0 || histogram.getCounts().stream().allMatch(i -> i == 0)) {
                throw new IllegalArgumentException("WF-405: Empty histogram");
            }
        } else if ((metric.charAt(0) == '\u2206' || metric.charAt(0) == '\u0394') && ((Number)value).doubleValue() <= 0.0) {
            throw new IllegalArgumentException("WF-404: Delta metrics cannot be non-positive");
        }
    }

    public static void validateSpan(Span span, @Nullable ValidationConfiguration config) {
        if (config == null) {
            return;
        }
        String source = span.getSource();
        String spanName = span.getName();
        if (StringUtils.isBlank((String)source)) {
            ((Counter)ERROR_COUNTERS.get((Object)"spanSourceMissing")).inc();
            throw new IllegalArgumentException("WF-426: Span source/host name is required");
        }
        if (source.length() > config.getHostLengthLimit()) {
            ((Counter)ERROR_COUNTERS.get((Object)"spanSourceTooLong")).inc();
            throw new IllegalArgumentException("WF-427: Span source/host name is too long (" + source.length() + " characters, max: " + config.getHostLengthLimit() + "): " + source);
        }
        if (spanName.length() > config.getSpanLengthLimit()) {
            ((Counter)ERROR_COUNTERS.get((Object)"spanNameTooLong")).inc();
            throw new IllegalArgumentException("WF-428: Span name is too long (" + source.length() + " characters, max: " + config.getSpanLengthLimit() + "): " + spanName);
        }
        if (spanName.contains("*")) {
            ((Counter)ERROR_COUNTERS.get((Object)"spanNameBadChars")).inc();
            throw new IllegalArgumentException("WF-415: Span name has illegal character *: " + spanName);
        }
        List<Annotation> annotations = span.getAnnotations();
        if (annotations != null) {
            if (annotations.size() > config.getSpanAnnotationsCountLimit()) {
                ((Counter)ERROR_COUNTERS.get((Object)"spanTooManyAnnotations")).inc();
                throw new IllegalArgumentException("WF-430: Span has too many annotations (" + annotations.size() + ", max " + config.getSpanAnnotationsCountLimit() + ")");
            }
            for (Annotation annotation : annotations) {
                String tagK = annotation.getKey();
                String tagV = annotation.getValue();
                if (tagK.length() > config.getSpanAnnotationsKeyLengthLimit()) {
                    ((Counter)ERROR_COUNTERS.get((Object)"spanAnnotationKeyTooLong")).inc();
                    throw new IllegalArgumentException("WF-432: Span annotation key is too long (" + tagK.length() + " characters, max: " + config.getSpanAnnotationsKeyLengthLimit() + "): " + tagK);
                }
                if (!Validation.charactersAreValid(tagK)) {
                    ((Counter)ERROR_COUNTERS.get((Object)"spanAnnotationKeyBadChars")).inc();
                    throw new IllegalArgumentException("WF-416: Span annotation key has illegal character(s): " + tagK);
                }
                if (tagV.length() <= config.getSpanAnnotationsValueLengthLimit()) continue;
                if (blockedLoggingRateLimiter.tryAcquire()) {
                    log.warning("WF-433: Span annotation value for " + tagK + " is too long (" + tagV.length() + " characters, max: " + config.getSpanAnnotationsValueLengthLimit() + "), value will be truncated: " + tagV);
                }
                annotation.setValue(tagV.substring(0, config.getSpanAnnotationsValueLengthLimit()));
                ((Counter)ERROR_COUNTERS.get((Object)"spanAnnotationValueTruncated")).inc();
            }
        }
    }

    @Deprecated
    public static void validatePoint(ReportPoint point, String source, @Nullable Level validationLevel) {
        Object pointValue = point.getValue();
        if (StringUtils.isBlank((String)point.getHost())) {
            throw new IllegalArgumentException("WF-301: Source/host name is required");
        }
        if (point.getHost().length() >= 1024) {
            throw new IllegalArgumentException("WF-301: Source/host name is too long: " + point.getHost());
        }
        if (point.getMetric().length() >= 1024) {
            throw new IllegalArgumentException("WF-301: Metric name is too long: " + point.getMetric());
        }
        if (!Validation.charactersAreValid(point.getMetric())) {
            ((Counter)ERROR_COUNTERS.get((Object)"badchars")).inc();
            throw new IllegalArgumentException("WF-400 " + source + ": Point metric has illegal character");
        }
        if (point.getAnnotations() != null) {
            if (!Validation.annotationKeysAreValid(point)) {
                throw new IllegalArgumentException("WF-401 " + source + ": Point annotation key has illegal character");
            }
            for (Map.Entry<String, String> tag : point.getAnnotations().entrySet()) {
                if (tag.getKey().length() + tag.getValue().length() < 255) continue;
                throw new IllegalArgumentException("Tag too long: " + tag.getKey() + "=" + tag.getValue());
            }
        }
        if (validationLevel != null && !validationLevel.equals((Object)Level.NO_VALIDATION)) {
            switch (validationLevel) {
                case NUMERIC_ONLY: {
                    Histogram histogram;
                    if (!(pointValue instanceof Long || pointValue instanceof Double || pointValue instanceof Histogram)) {
                        throw new IllegalArgumentException("WF-403 " + source + ": Was not long/double/histogram object");
                    }
                    if (!(pointValue instanceof Histogram) || (histogram = (Histogram)((Object)pointValue)).getCounts().size() != 0 && histogram.getBins().size() != 0 && !histogram.getCounts().stream().allMatch(i -> i == 0)) break;
                    throw new IllegalArgumentException("WF-405 " + source + ": Empty histogram");
                }
            }
        }
    }

    public static enum Level {
        NO_VALIDATION,
        NUMERIC_ONLY;

    }
}

