/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import wavefront.report.ReportSourceTag;
import wavefront.report.SourceOperationType;
import wavefront.report.SourceTagAction;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SourceTag
implements Serializable {
    @JsonProperty
    private SourceOperationType operation;
    @JsonProperty
    private SourceTagAction action;
    @JsonProperty
    private String source;
    @JsonProperty
    private List<String> annotations;

    private SourceTag() {
    }

    public SourceTag(ReportSourceTag sourceTag) {
        this.operation = sourceTag.getOperation();
        this.action = sourceTag.getAction();
        this.source = sourceTag.getSource();
        this.annotations = new ArrayList<String>(sourceTag.getAnnotations());
    }

    public SourceOperationType getOperation() {
        return this.operation;
    }

    public SourceTagAction getAction() {
        return this.action;
    }

    public String getSource() {
        return this.source;
    }

    public List<String> getAnnotations() {
        return this.annotations;
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.operation == null ? 0 : this.operation.hashCode());
        result = result * 31 + (this.action == null ? 0 : this.action.hashCode());
        result = result * 31 + (this.source == null ? 0 : this.source.hashCode());
        result = result * 31 + (this.annotations == null ? 0 : this.annotations.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SourceTag other = (SourceTag)obj;
        if (!Objects.equals((Object)this.operation, (Object)other.operation)) {
            return false;
        }
        if (!Objects.equals((Object)this.action, (Object)other.action)) {
            return false;
        }
        if (!Objects.equals(this.source, other.source)) {
            return false;
        }
        return Objects.equals(this.annotations, other.annotations);
    }
}

