/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.wavefront.ingester.ReportPointIngesterFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.IntStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.apache.commons.lang.StringUtils;
import queryserver.parser.DSWrapperLexer;
import wavefront.report.Annotation;
import wavefront.report.Histogram;
import wavefront.report.HistogramType;
import wavefront.report.ReportEvent;
import wavefront.report.ReportPoint;
import wavefront.report.ReportSourceTag;
import wavefront.report.SourceOperationType;
import wavefront.report.Span;

public abstract class AbstractIngesterFormatter<T> {
    protected static final FormatterElement WHITESPACE_ELEMENT = new Whitespace();
    public static final String SOURCE_TAG_LITERAL = "@SourceTag";
    public static final String SOURCE_DESCRIPTION_LITERAL = "@SourceDescription";
    private static final char SINGLE_QUOTE = '\'';
    private static final String SINGLE_QUOTE_STR = String.valueOf('\'');
    private static final char SLASH = '\\';
    private static final String ESCAPED_SINGLE_QUOTE_STR = '\\' + SINGLE_QUOTE_STR;
    private static final char DOUBLE_QUOTE = '\"';
    private static final String DOUBLE_QUOTE_STR = String.valueOf('\"');
    private static final String ESCAPED_DOUBLE_QUOTE_STR = '\\' + DOUBLE_QUOTE_STR;
    private static final BaseErrorListener THROWING_ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            throw new RuntimeException("Syntax error at line " + line + ", position " + charPositionInLine + ": " + msg, e);
        }
    };
    protected final List<FormatterElement> elements;
    protected static final ThreadLocal<DSWrapperLexer> dsWrapperLexerThreadLocal = new ThreadLocal<DSWrapperLexer>(){

        @Override
        protected DSWrapperLexer initialValue() {
            DSWrapperLexer lexer = new DSWrapperLexer((CharStream)CharStreams.fromString((String)""));
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)THROWING_ERROR_LISTENER);
            return lexer;
        }
    };

    AbstractIngesterFormatter(List<FormatterElement> elements) {
        this.elements = elements;
    }

    protected Queue<Token> getQueue(String input) {
        DSWrapperLexer lexer = dsWrapperLexerThreadLocal.get();
        lexer.setInputStream((IntStream)CharStreams.fromString((String)input));
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)lexer);
        commonTokenStream.fill();
        List tokens = commonTokenStream.getTokens();
        if (tokens.isEmpty()) {
            throw new RuntimeException("Could not parse: " + input);
        }
        Queue queue = tokens.stream().filter(t -> t.getType() != -1).collect(Collectors.toCollection(ArrayDeque::new));
        return queue;
    }

    private static double parseValue(Queue<Token> tokenQueue, String name) {
        String value = "";
        Token current = tokenQueue.poll();
        if (current == null) {
            throw new RuntimeException("Invalid " + name + ", found EOF");
        }
        if (current.getType() == 4) {
            current = tokenQueue.poll();
            value = "-";
        }
        if (current == null) {
            throw new RuntimeException("Invalid " + name + ", found EOF");
        }
        if (current.getType() == 9) {
            if (!value.equals("")) {
                throw new RuntimeException("Invalid " + name + ": " + value + current.getText());
            }
            value = value + AbstractIngesterFormatter.unquote(current.getText());
        } else if (current.getType() == 8 || current.getType() == 10 || current.getType() == 7) {
            value = value + current.getText();
        } else {
            throw new RuntimeException("Invalid " + name + ": " + current.getText());
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nef) {
            throw new RuntimeException("Invalid " + name + ": " + value);
        }
    }

    private static Long parseTimestamp(Queue<Token> tokenQueue, boolean optional, boolean convertToMillis) {
        Token peek = tokenQueue.peek();
        if (peek == null || peek.getType() != 7) {
            if (optional) {
                return null;
            }
            throw new RuntimeException("Expected timestamp, found " + (peek == null ? "EOF" : peek.getText()));
        }
        try {
            Double timestamp = Double.parseDouble(tokenQueue.poll().getText());
            Long timestampLong = timestamp.longValue();
            if (!convertToMillis) {
                return timestampLong;
            }
            if (timestampLong > 999999999999999999L) {
                return timestampLong / 1000000L;
            }
            if (timestampLong > 999999999999999L) {
                return timestampLong / 1000L;
            }
            if (timestampLong > 999999999999L) {
                return timestampLong;
            }
            return (long)(1000.0 * timestamp);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Invalid timestamp value: " + peek.getText());
        }
    }

    protected static String getLiteral(Queue<Token> tokens) {
        StringBuilder toReturn = new StringBuilder();
        Token next = tokens.peek();
        if (next == null) {
            return "";
        }
        if (next.getType() == 9) {
            return AbstractIngesterFormatter.unquote(tokens.poll().getText());
        }
        while (next != null && (next.getType() == 8 || next.getType() == 11 || next.getType() == 7 || next.getType() == 15 || next.getType() == 16 || next.getType() == 10 || next.getType() == 3 || next.getType() == 4 || next.getType() == 6 || next.getType() == 17)) {
            toReturn.append(tokens.poll().getText());
            next = tokens.peek();
        }
        return toReturn.toString();
    }

    public static String unquote(String text) {
        if (text.startsWith(DOUBLE_QUOTE_STR)) {
            String quoteless = text.substring(1, text.length() - 1);
            if (StringUtils.containsAny((String)quoteless, (String)ESCAPED_DOUBLE_QUOTE_STR)) {
                return StringUtils.replace((String)quoteless, (String)ESCAPED_DOUBLE_QUOTE_STR, (String)DOUBLE_QUOTE_STR);
            }
            return quoteless;
        }
        if (text.startsWith(SINGLE_QUOTE_STR)) {
            String quoteless = text.substring(1, text.length() - 1);
            if (StringUtils.containsAny((String)quoteless, (String)ESCAPED_SINGLE_QUOTE_STR)) {
                return StringUtils.replace((String)quoteless, (String)ESCAPED_SINGLE_QUOTE_STR, (String)SINGLE_QUOTE_STR);
            }
            return quoteless;
        }
        return text;
    }

    public T drive(String input, String defaultHostName, String customerId) {
        return this.drive(input, defaultHostName, customerId, null);
    }

    public abstract T drive(String var1, String var2, String var3, @Nullable List<String> var4);

    static <T> T computeIfNull(@Nullable T input, Supplier<T> supplier) {
        if (input == null) {
            return supplier.get();
        }
        return input;
    }

    public static class Literal
    implements FormatterElement {
        private final String literal;
        private final boolean caseSensitive;

        public Literal(String literal, boolean caseSensitive) {
            this.literal = literal;
            this.caseSensitive = caseSensitive;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            boolean equals;
            if (tokenQueue.isEmpty()) {
                throw new RuntimeException("End of line reached, expecting a literal string: " + this.literal);
            }
            String next = AbstractIngesterFormatter.getLiteral(tokenQueue);
            boolean bl = equals = this.caseSensitive ? next.equals(this.literal) : next.equalsIgnoreCase(this.literal);
            if (!equals) {
                throw new RuntimeException("Expecting a literal string: " + this.literal + " but found: " + this.literal);
            }
        }
    }

    public static class Literals
    implements FormatterElement {
        private final String[] literals;
        private final boolean caseSensitive;

        public Literals(@Nonnull String[] literals, boolean caseSensitive) {
            this.literals = literals;
            this.caseSensitive = caseSensitive;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            if (tokenQueue.isEmpty()) {
                throw new RuntimeException("Reached end of line, expecting one of: " + String.join((CharSequence)", ", this.literals));
            }
            String literal = AbstractIngesterFormatter.getLiteral(tokenQueue);
            for (String specLiteral : this.literals) {
                if (this.caseSensitive && literal.equals(specLiteral)) {
                    point.setLiteral(literal);
                    return;
                }
                if (this.caseSensitive || !literal.equalsIgnoreCase(specLiteral)) continue;
                point.setLiteral(literal);
                return;
            }
            throw new RuntimeException("Expecting one of: " + String.join((CharSequence)", ", this.literals) + " but found: " + literal);
        }
    }

    public static class SourceTagKeywords
    implements FormatterElement {
        private final FormatterElement tagElement = new Tag();

        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper sourceTag) {
            WHITESPACE_ELEMENT.consume(tokenQueue, sourceTag);
            this.tagElement.consume(tokenQueue, sourceTag);
            WHITESPACE_ELEMENT.consume(tokenQueue, sourceTag);
            this.tagElement.consume(tokenQueue, sourceTag);
        }
    }

    public static class Whitespace
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> tokens, AbstractWrapper point) {
            while (!tokens.isEmpty() && tokens.peek().getType() == 18) {
                tokens.poll();
            }
        }
    }

    public static class Metric
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            String metric = AbstractIngesterFormatter.getLiteral(tokenQueue);
            if (metric.length() == 0) {
                throw new RuntimeException("Invalid metric name");
            }
            point.setMetric(metric);
        }
    }

    public static class Timestamp
    implements FormatterElement {
        private final TimeUnit timeUnit;
        private final boolean optional;

        public Timestamp(TimeUnit timeUnit, boolean optional) {
            this.timeUnit = timeUnit;
            this.optional = optional;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            Token peek = tokenQueue.peek();
            if (peek == null) {
                if (this.optional) {
                    return;
                }
                throw new RuntimeException("Expecting timestamp, found EOF");
            }
            if (peek.getType() == 7) {
                try {
                    long multiplier = this.timeUnit.toMillis(1L);
                    if (multiplier < 1L) {
                        point.setTimestamp(this.timeUnit.toMillis((long)Double.parseDouble(tokenQueue.poll().getText())));
                    }
                    point.setTimestamp((long)((double)multiplier * Double.parseDouble(tokenQueue.poll().getText())));
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException("Invalid timestamp value: " + peek.getText());
                }
            } else if (!this.optional) {
                throw new RuntimeException("Expecting timestamp, found: " + peek.getText());
            }
        }
    }

    public static class AdaptiveEndTimestamp
    implements FormatterElement {
        private final boolean optional;
        private final boolean convertToMillis;

        public AdaptiveEndTimestamp(boolean optional) {
            this(optional, true);
        }

        public AdaptiveEndTimestamp(boolean optional, boolean convertToMillis) {
            this.optional = optional;
            this.convertToMillis = convertToMillis;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            Long timestamp = AbstractIngesterFormatter.parseTimestamp(tokenQueue, this.optional, this.convertToMillis);
            if (timestamp != null) {
                point.setEndTimestamp(timestamp);
            }
        }
    }

    public static class AdaptiveTimestamp
    implements FormatterElement {
        private final boolean optional;
        private final boolean convertToMillis;

        public AdaptiveTimestamp(boolean optional) {
            this(optional, true);
        }

        public AdaptiveTimestamp(boolean optional, boolean convertToMillis) {
            this.optional = optional;
            this.convertToMillis = convertToMillis;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            Long timestamp = AbstractIngesterFormatter.parseTimestamp(tokenQueue, this.optional, this.convertToMillis);
            if (timestamp != null) {
                point.setTimestamp(timestamp);
            }
        }
    }

    public static class Name
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            String name = AbstractIngesterFormatter.getLiteral(tokenQueue);
            if (name.length() == 0) {
                throw new RuntimeException("Invalid name");
            }
            point.setName(name);
        }
    }

    public static class Duration
    implements FormatterElement {
        private final boolean optional;

        public Duration(boolean optional) {
            this.optional = optional;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper wrapper) {
            Long timestamp = AbstractIngesterFormatter.parseTimestamp(tokenQueue, this.optional, false);
            Long startTs = wrapper.getTimestamp();
            if (timestamp != null && startTs != null) {
                long duration;
                long l = duration = timestamp - startTs >= 0L ? timestamp - startTs : timestamp;
                if (startTs > 999999999999999999L) {
                    wrapper.setTimestamp(startTs / 1000000L);
                    wrapper.setDuration(duration / 1000000L);
                } else if (startTs > 999999999999999L) {
                    wrapper.setTimestamp(startTs / 1000L);
                    wrapper.setDuration(duration / 1000L);
                } else if (startTs > 999999999999L) {
                    wrapper.setDuration(duration);
                } else {
                    wrapper.setTimestamp(startTs * 1000L);
                    wrapper.setDuration(duration * 1000L);
                }
            } else {
                throw new RuntimeException("Both timestamp and duration expected");
            }
        }
    }

    public static class Value
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            point.setValue(AbstractIngesterFormatter.parseValue(tokenQueue, "metric value"));
        }
    }

    public static class AlphaNumericValue
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper sourceTag) {
            WHITESPACE_ELEMENT.consume(tokenQueue, sourceTag);
            String value = "";
            Token current = tokenQueue.poll();
            if (current == null) {
                throw new RuntimeException("Invalid value, found EOF");
            }
            if (current.getType() == 9) {
                if (!value.equals("")) {
                    throw new RuntimeException("invalid metric value: " + value + current.getText());
                }
                value = value + ReportPointIngesterFormatter.unquote(current.getText());
            } else if (current.getType() == 8 || current.getType() == 10 || current.getType() == 7) {
                value = value + current.getText();
            } else {
                throw new RuntimeException("invalid value: " + current.getText());
            }
            sourceTag.addAnnotation(value);
        }
    }

    public static class Tag
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> queue, AbstractWrapper point) {
            String tagk = AbstractIngesterFormatter.getLiteral(queue);
            if (tagk.length() == 0) {
                throw new RuntimeException("Invalid tag name");
            }
            WHITESPACE_ELEMENT.consume(queue, point);
            Token current = queue.poll();
            if (current == null || current.getType() != 1) {
                throw new RuntimeException("Tag keys and values must be separated by '='" + (current != null ? ", found: " + current.getText() : ", found EOF"));
            }
            WHITESPACE_ELEMENT.consume(queue, point);
            String tagv = AbstractIngesterFormatter.getLiteral(queue);
            if (tagv.length() == 0) {
                throw new RuntimeException("Invalid tag value for: " + tagk);
            }
            point.addAnnotation(tagk, tagv);
        }
    }

    public static class TimestampAdjuster
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            Preconditions.checkArgument((point.getValue() != null && point.getTimestamp() != null && point.getValue() instanceof Histogram && ((Histogram)((Object)point.getValue())).getDuration() != null ? 1 : 0) != 0, (Object)"Expected a histogram point with timestamp and histogram duration");
            long duration = ((Histogram)((Object)point.getValue())).getDuration().intValue();
            point.setTimestamp(point.getTimestamp() / duration * duration);
        }
    }

    public static class GuardedLoop
    implements FormatterElement {
        private final FormatterElement element;
        private final Set<Integer> acceptedTokens;
        private final boolean optional;

        public GuardedLoop(FormatterElement element, int acceptedToken, boolean optional) {
            this.element = element;
            this.acceptedTokens = ImmutableSortedSet.of((Comparable)Integer.valueOf(acceptedToken));
            this.optional = optional;
        }

        public GuardedLoop(FormatterElement element, Set<Integer> acceptedTokens, boolean optional) {
            this.element = element;
            this.acceptedTokens = acceptedTokens;
            this.optional = optional;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            boolean satisfied = this.optional;
            while (!tokenQueue.isEmpty()) {
                WHITESPACE_ELEMENT.consume(tokenQueue, point);
                if (tokenQueue.peek() == null || !this.acceptedTokens.contains(tokenQueue.peek().getType())) break;
                satisfied = true;
                this.element.consume(tokenQueue, point);
            }
            if (!satisfied) {
                throw new RuntimeException("Expected at least one element, got none");
            }
        }
    }

    public static class Centroid
    implements FormatterElement {
        public static int expectedToken() {
            return 13;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            int count;
            Token peek = tokenQueue.peek();
            Preconditions.checkNotNull((Object)peek, (Object)"Expected Count, got EOF");
            Preconditions.checkArgument((peek.getType() == 13 ? 1 : 0) != 0, (Object)("Expected Count, got " + peek.getText()));
            String countStr = tokenQueue.poll().getText();
            try {
                count = Integer.parseInt(countStr.substring(1));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Could not parse count " + countStr);
            }
            WHITESPACE_ELEMENT.consume(tokenQueue, point);
            double mean = AbstractIngesterFormatter.parseValue(tokenQueue, "centroid mean");
            Histogram h = AbstractIngesterFormatter.computeIfNull((Histogram)((Object)point.getValue()), Histogram::new);
            List bins = AbstractIngesterFormatter.computeIfNull(h.getBins(), ArrayList::new);
            bins.add(mean);
            h.setBins(bins);
            List counts = AbstractIngesterFormatter.computeIfNull(h.getCounts(), ArrayList::new);
            counts.add(count);
            h.setCounts(counts);
            point.setValue(h);
        }
    }

    public static class BinType
    implements FormatterElement {
        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            String binType;
            Token peek = tokenQueue.peek();
            if (peek == null) {
                throw new RuntimeException("Expected BinType, found EOF");
            }
            if (peek.getType() != 12) {
                throw new RuntimeException("Expected BinType, found " + peek.getText());
            }
            int durationMillis = 0;
            switch (binType = tokenQueue.poll().getText()) {
                case "!M": {
                    durationMillis = 60000;
                    break;
                }
                case "!H": {
                    durationMillis = 3600000;
                    break;
                }
                case "!D": {
                    durationMillis = 86400000;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown BinType " + binType);
                }
            }
            Histogram h = AbstractIngesterFormatter.computeIfNull((Histogram)((Object)point.getValue()), Histogram::new);
            h.setDuration(durationMillis);
            h.setType(HistogramType.TDIGEST);
            point.setValue(h);
        }
    }

    public static class Loop
    implements FormatterElement {
        private final FormatterElement element;

        public Loop(FormatterElement element) {
            this.element = element;
        }

        @Override
        public void consume(Queue<Token> tokenQueue, AbstractWrapper point) {
            while (!tokenQueue.isEmpty()) {
                WHITESPACE_ELEMENT.consume(tokenQueue, point);
                if (tokenQueue.isEmpty()) {
                    return;
                }
                this.element.consume(tokenQueue, point);
            }
        }
    }

    public static abstract class IngesterFormatBuilder<T> {
        final List<FormatterElement> elements = Lists.newArrayList();

        public IngesterFormatBuilder<T> appendCaseSensitiveLiteral(String literal) {
            this.elements.add(new Literal(literal, true));
            return this;
        }

        public IngesterFormatBuilder<T> appendCaseSensitiveLiterals(String[] literals) {
            this.elements.add(new Literals(literals, true));
            return this;
        }

        public IngesterFormatBuilder<T> appendCaseInsensitiveLiteral(String literal) {
            this.elements.add(new Literal(literal, false));
            return this;
        }

        public IngesterFormatBuilder<T> appendMetricName() {
            this.elements.add(new Metric());
            return this;
        }

        public IngesterFormatBuilder<T> appendValue() {
            this.elements.add(new Value());
            return this;
        }

        public IngesterFormatBuilder<T> appendTimestamp() {
            this.elements.add(new AdaptiveTimestamp(false));
            return this;
        }

        public IngesterFormatBuilder<T> appendOptionalTimestamp() {
            this.elements.add(new AdaptiveTimestamp(true));
            return this;
        }

        public IngesterFormatBuilder<T> appendOptionalEndTimestamp() {
            this.elements.add(new AdaptiveEndTimestamp(true));
            return this;
        }

        public IngesterFormatBuilder<T> appendTimestamp(TimeUnit timeUnit) {
            this.elements.add(new Timestamp(timeUnit, false));
            return this;
        }

        public IngesterFormatBuilder<T> appendOptionalTimestamp(TimeUnit timeUnit) {
            this.elements.add(new Timestamp(timeUnit, true));
            return this;
        }

        public IngesterFormatBuilder<T> appendRawTimestamp() {
            this.elements.add(new AdaptiveTimestamp(false, false));
            return this;
        }

        public IngesterFormatBuilder<T> appendDuration() {
            this.elements.add(new Duration(false));
            return this;
        }

        public IngesterFormatBuilder<T> appendName() {
            this.elements.add(new Name());
            return this;
        }

        public IngesterFormatBuilder<T> appendBoundedAnnotationsConsumer() {
            this.elements.add(new GuardedLoop((FormatterElement)new Tag(), (Set<Integer>)ImmutableSortedSet.of((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(8), (Comparable)Integer.valueOf(9)), false));
            return this;
        }

        public IngesterFormatBuilder<T> appendAnnotationsConsumer() {
            this.elements.add(new Loop(new Tag()));
            return this;
        }

        public IngesterFormatBuilder<T> whiteSpace() {
            this.elements.add(new Whitespace());
            return this;
        }

        public IngesterFormatBuilder<T> binType() {
            this.elements.add(new BinType());
            return this;
        }

        public IngesterFormatBuilder<T> centroids() {
            this.elements.add(new GuardedLoop((FormatterElement)new Centroid(), Centroid.expectedToken(), false));
            return this;
        }

        public IngesterFormatBuilder<T> adjustTimestamp() {
            this.elements.add(new TimestampAdjuster());
            return this;
        }

        public IngesterFormatBuilder<T> appendLoopOfKeywords() {
            this.elements.add(new SourceTagKeywords());
            return this;
        }

        public IngesterFormatBuilder<T> appendLoopOfValues() {
            this.elements.add(new Loop(new AlphaNumericValue()));
            return this;
        }

        public abstract AbstractIngesterFormatter<T> build();
    }

    protected static interface FormatterElement {
        public void consume(Queue<Token> var1, AbstractWrapper var2);
    }

    protected static class EventWrapper
    extends AbstractWrapper {
        ReportEvent event;
        private String literal;
        private List<Annotation> annotations = new ArrayList<Annotation>();

        EventWrapper(ReportEvent event) {
            this.event = event;
        }

        @Override
        void setLiteral(String literal) {
            this.literal = literal;
        }

        @Override
        String getLiteral() {
            return this.literal;
        }

        @Override
        void setName(String name) {
            this.event.setName(name);
        }

        @Override
        void addAnnotation(String key, String value) {
            this.annotations.add(new Annotation(key, value));
        }

        List<Annotation> getAnnotationList() {
            return this.annotations;
        }

        @Override
        void setTimestamp(Long timestamp) {
            this.event.setStartTime(timestamp);
        }

        @Override
        void setEndTimestamp(Long timestamp) {
            this.event.setEndTime(timestamp);
        }
    }

    protected static class SpanWrapper
    extends AbstractWrapper {
        Span span;

        SpanWrapper(Span span) {
            this.span = span;
        }

        @Override
        void setDuration(Long value) {
            this.span.setDuration(value);
        }

        @Override
        Long getTimestamp() {
            return this.span.getStartMillis();
        }

        @Override
        void setTimestamp(Long value) {
            this.span.setStartMillis(value);
        }

        @Override
        void setName(String name) {
            this.span.setName(name);
        }

        @Override
        void addAnnotation(String key, String value) {
            if (this.span.getAnnotations() == null) {
                this.span.setAnnotations(Lists.newArrayList());
            }
            this.span.getAnnotations().add(new Annotation(key, value));
        }
    }

    protected static class ReportSourceTagWrapper
    extends AbstractWrapper {
        final ReportSourceTag reportSourceTag;
        final Map<String, String> annotations;

        ReportSourceTagWrapper(ReportSourceTag reportSourceTag) {
            this.reportSourceTag = reportSourceTag;
            this.annotations = Maps.newHashMap();
        }

        @Override
        String getLiteral() {
            switch (this.reportSourceTag.getOperation()) {
                case SOURCE_TAG: {
                    return AbstractIngesterFormatter.SOURCE_TAG_LITERAL;
                }
                case SOURCE_DESCRIPTION: {
                    return AbstractIngesterFormatter.SOURCE_DESCRIPTION_LITERAL;
                }
            }
            throw new IllegalArgumentException("Invalid operation " + (Object)((Object)this.reportSourceTag.getOperation()));
        }

        @Override
        void setLiteral(String literal) {
            switch (literal) {
                case "@SourceTag": {
                    this.reportSourceTag.setOperation(SourceOperationType.SOURCE_TAG);
                    return;
                }
                case "@SourceDescription": {
                    this.reportSourceTag.setOperation(SourceOperationType.SOURCE_DESCRIPTION);
                    return;
                }
            }
            throw new IllegalArgumentException("Literal " + literal + " is not allowed!");
        }

        @Override
        void addAnnotation(String key, String value) {
            this.annotations.put(key, value);
        }

        @Override
        void addAnnotation(String value) {
            if (this.reportSourceTag.getAnnotations() == null) {
                this.reportSourceTag.setAnnotations(Lists.newArrayList());
            }
            this.reportSourceTag.getAnnotations().add(value);
        }

        @NotNull
        Map<String, String> getAnnotationMap() {
            return this.annotations;
        }
    }

    protected static class ReportPointWrapper
    extends AbstractWrapper {
        ReportPoint reportPoint;

        ReportPointWrapper(ReportPoint reportPoint) {
            this.reportPoint = reportPoint;
        }

        @Override
        Object getValue() {
            return this.reportPoint.getValue();
        }

        @Override
        void setValue(Histogram value) {
            this.reportPoint.setValue(value);
        }

        @Override
        void setValue(double value) {
            this.reportPoint.setValue(value);
        }

        @Override
        void setValue(Long value) {
            this.reportPoint.setValue(value);
        }

        @Override
        Long getTimestamp() {
            return this.reportPoint.getTimestamp();
        }

        @Override
        void setTimestamp(Long value) {
            this.reportPoint.setTimestamp(value);
        }

        @Override
        void addAnnotation(String key, String value) {
            if (this.reportPoint.getAnnotations() == null) {
                this.reportPoint.setAnnotations(new HashMap<String, String>());
            }
            this.reportPoint.getAnnotations().put(key, value);
        }

        @Override
        void setMetric(String value) {
            this.reportPoint.setMetric(value);
        }
    }

    protected static abstract class AbstractWrapper {
        protected AbstractWrapper() {
        }

        Object getValue() {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setValue(Histogram value) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setValue(double value) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setValue(Long value) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        Long getTimestamp() {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setTimestamp(Long value) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setDuration(Long value) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void addAnnotation(String key, String value) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void addAnnotation(String value) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setMetric(String value) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        String getLiteral() {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setLiteral(String literal) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setCustomer(String name) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setName(String value) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }

        void setEndTimestamp(Long value) {
            throw new UnsupportedOperationException("Should not be invoked.");
        }
    }
}

