/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.wavefront.ingester.AbstractIngesterFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.Token;
import wavefront.report.Annotation;
import wavefront.report.ReportEvent;

public class EventIngesterFormatter
extends AbstractIngesterFormatter<ReportEvent> {
    private EventIngesterFormatter(List<AbstractIngesterFormatter.FormatterElement> elements) {
        super(elements);
    }

    public static AbstractIngesterFormatter.IngesterFormatBuilder<ReportEvent> newBuilder() {
        return new EventIngesterFormatBuilder();
    }

    @Override
    public ReportEvent drive(String input, String defaultHostName, String customerId, @Nullable List<String> customSourceTags) {
        Queue<Token> queue = this.getQueue(input);
        ReportEvent event = new ReportEvent();
        event.setAnnotations(new HashMap<String, String>());
        AbstractIngesterFormatter.EventWrapper wrapper = new AbstractIngesterFormatter.EventWrapper(event);
        try {
            for (AbstractIngesterFormatter.FormatterElement element : this.elements) {
                element.consume(queue, wrapper);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not parse: " + input, ex);
        }
        block12: for (Annotation annotation : wrapper.getAnnotationList()) {
            switch (annotation.getKey()) {
                case "host": {
                    if (event.getHosts() == null) {
                        event.setHosts(new ArrayList<String>());
                    }
                    event.getHosts().add(annotation.getValue());
                    continue block12;
                }
                case "tag": 
                case "eventTag": {
                    if (event.getTags() == null) {
                        event.setTags(new ArrayList<String>());
                    }
                    event.getTags().add(annotation.getValue());
                    continue block12;
                }
            }
            Map<String, List<String>> dimensions = event.getDimensions();
            if (dimensions != null && dimensions.containsKey(annotation.getKey())) {
                dimensions.get(annotation.getKey()).add(annotation.getValue());
                continue;
            }
            if (event.getAnnotations().containsKey(annotation.getKey())) {
                if (dimensions == null) {
                    event.setDimensions(new HashMap<String, List<String>>());
                }
                ArrayList<String> multivalue = new ArrayList<String>();
                multivalue.add(event.getAnnotations().remove(annotation.getKey()));
                multivalue.add(annotation.getValue());
                event.getDimensions().put(annotation.getKey(), multivalue);
                continue;
            }
            event.getAnnotations().put(annotation.getKey(), annotation.getValue());
        }
        if (event.getEndTime() == null || event.getEndTime() == 0L) {
            event.setEndTime(event.getStartTime() + 1L);
        }
        return ReportEvent.newBuilder(event).build();
    }

    public static class EventIngesterFormatBuilder
    extends AbstractIngesterFormatter.IngesterFormatBuilder<ReportEvent> {
        public EventIngesterFormatter build() {
            return new EventIngesterFormatter(this.elements);
        }
    }
}

