/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.annotations.VisibleForTesting;
import java.util.function.Function;
import org.apache.commons.lang.StringUtils;
import wavefront.report.ReportSourceTag;

public class ReportSourceTagSerializer
implements Function<ReportSourceTag, String> {
    @Override
    public String apply(ReportSourceTag input) {
        return ReportSourceTagSerializer.sourceTagToString(input);
    }

    private static String escapeQuotes(String raw) {
        return StringUtils.replace((String)raw, (String)"\"", (String)"\\\"");
    }

    @VisibleForTesting
    static String sourceTagToString(ReportSourceTag sourceTag) {
        StringBuilder sb = new StringBuilder();
        switch (sourceTag.getOperation()) {
            case SOURCE_TAG: {
                sb.append("@SourceTag");
                break;
            }
            case SOURCE_DESCRIPTION: {
                sb.append("@SourceDescription");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation: " + (Object)((Object)sourceTag.getOperation()));
            }
        }
        sb.append(" action=");
        switch (sourceTag.getAction()) {
            case SAVE: {
                sb.append("save");
                break;
            }
            case ADD: {
                sb.append("add");
                break;
            }
            case DELETE: {
                sb.append("delete");
                break;
            }
            default: {
                sb.append("<unknown>");
            }
        }
        sb.append(" source=\"");
        sb.append(ReportSourceTagSerializer.escapeQuotes(sourceTag.getSource()));
        sb.append("\" ");
        sourceTag.getAnnotations().forEach(x -> sb.append("\"").append(ReportSourceTagSerializer.escapeQuotes(x)).append("\""));
        return sb.toString();
    }
}

