/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.wavefront.ingester.AbstractIngesterFormatter;
import java.util.List;
import java.util.Queue;
import org.antlr.v4.runtime.Token;
import wavefront.report.ReportSourceTag;
import wavefront.report.SourceOperationType;
import wavefront.report.SourceTagAction;

public class ReportSourceTagIngesterFormatter
extends AbstractIngesterFormatter<ReportSourceTag> {
    private static final String SOURCE = "source";
    private static final String ACTION = "action";
    private static final String ACTION_ADD = "add";
    private static final String ACTION_SAVE = "save";
    private static final String ACTION_DELETE = "delete";

    private ReportSourceTagIngesterFormatter(List<AbstractIngesterFormatter.FormatterElement> elements) {
        super(elements);
    }

    public static SourceTagIngesterFormatBuilder newBuilder() {
        return new SourceTagIngesterFormatBuilder();
    }

    @Override
    public ReportSourceTag drive(String input, String defaultHostName, String customerId, List<String> customerSourceTags) {
        Queue<Token> queue = this.getQueue(input);
        ReportSourceTag sourceTag = new ReportSourceTag();
        AbstractIngesterFormatter.ReportSourceTagWrapper wrapper = new AbstractIngesterFormatter.ReportSourceTagWrapper(sourceTag);
        try {
            for (Object element : this.elements) {
                element.consume(queue, wrapper);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not parse: " + input, ex);
        }
        String action = wrapper.getAnnotationMap().get(ACTION);
        if (action == null) {
            throw new IllegalArgumentException("No action key was present in the input: " + input);
        }
        switch (action.toLowerCase()) {
            case "add": {
                sourceTag.setAction(SourceTagAction.ADD);
                break;
            }
            case "save": {
                sourceTag.setAction(SourceTagAction.SAVE);
                break;
            }
            case "delete": {
                sourceTag.setAction(SourceTagAction.DELETE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid action '" + action + "'!");
            }
        }
        String source = wrapper.getAnnotationMap().get(SOURCE);
        if (source == null) {
            throw new IllegalArgumentException("No source key was present in the input: " + input);
        }
        sourceTag.setSource(source);
        if (sourceTag.getAnnotations() == null || sourceTag.getAnnotations().isEmpty()) {
            if (sourceTag.getOperation() != SourceOperationType.SOURCE_DESCRIPTION || sourceTag.getAction() != SourceTagAction.DELETE) {
                throw new IllegalArgumentException("No data provided for operation `" + (Object)((Object)sourceTag.getOperation()) + "` action: " + (Object)((Object)sourceTag.getAction()));
            }
        } else if (sourceTag.getOperation() == SourceOperationType.SOURCE_DESCRIPTION && sourceTag.getAnnotations().size() > 1) {
            throw new IllegalArgumentException("Only one description expected");
        }
        return ReportSourceTag.newBuilder(sourceTag).build();
    }

    public static class SourceTagIngesterFormatBuilder
    extends AbstractIngesterFormatter.IngesterFormatBuilder<ReportSourceTag> {
        public ReportSourceTagIngesterFormatter build() {
            return new ReportSourceTagIngesterFormatter(this.elements);
        }
    }
}

