/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.common;

import com.google.common.collect.ImmutableMap;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Metered;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Sampling;
import com.yammer.metrics.core.Summarizable;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.core.VirtualMachineMetrics;
import com.yammer.metrics.stats.Snapshot;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public abstract class MetricsToTimeseries {
    private static final Pattern SIMPLE_NAMES = Pattern.compile("[^a-zA-Z0-9_.\\-~]");

    public static Map<String, Double> explodeSummarizable(Summarizable metric) {
        return MetricsToTimeseries.explodeSummarizable(metric, false);
    }

    public static Map<String, Double> explodeSummarizable(Summarizable metric, boolean convertNanToZero) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"min", (Object)MetricsToTimeseries.sanitizeValue(metric.min(), convertNanToZero)).put((Object)"max", (Object)MetricsToTimeseries.sanitizeValue(metric.max(), convertNanToZero)).put((Object)"mean", (Object)MetricsToTimeseries.sanitizeValue(metric.mean(), convertNanToZero));
        if (metric instanceof Histogram || metric instanceof Timer) {
            builder.put((Object)"sum", (Object)MetricsToTimeseries.sanitizeValue(metric.sum(), convertNanToZero));
            builder.put((Object)"stddev", (Object)MetricsToTimeseries.sanitizeValue(metric.stdDev(), convertNanToZero));
        }
        return builder.build();
    }

    public static Map<String, Double> explodeSampling(Sampling sampling) {
        return MetricsToTimeseries.explodeSampling(sampling, false);
    }

    public static Map<String, Double> explodeSampling(Sampling sampling, boolean convertNanToZero) {
        Snapshot snapshot = sampling.getSnapshot();
        return ImmutableMap.builder().put((Object)"median", (Object)MetricsToTimeseries.sanitizeValue(snapshot.getMedian(), convertNanToZero)).put((Object)"p75", (Object)MetricsToTimeseries.sanitizeValue(snapshot.get75thPercentile(), convertNanToZero)).put((Object)"p95", (Object)MetricsToTimeseries.sanitizeValue(snapshot.get95thPercentile(), convertNanToZero)).put((Object)"p99", (Object)MetricsToTimeseries.sanitizeValue(snapshot.get99thPercentile(), convertNanToZero)).put((Object)"p999", (Object)MetricsToTimeseries.sanitizeValue(snapshot.get999thPercentile(), convertNanToZero)).build();
    }

    public static Map<String, Double> explodeMetered(Metered metered) {
        return ImmutableMap.builder().put((Object)"count", (Object)new Long(metered.count()).doubleValue()).put((Object)"mean", (Object)metered.meanRate()).put((Object)"m1", (Object)metered.oneMinuteRate()).put((Object)"m5", (Object)metered.fiveMinuteRate()).put((Object)"m15", (Object)metered.fifteenMinuteRate()).build();
    }

    public static Map<String, Double> memoryMetrics(VirtualMachineMetrics vm) {
        return ImmutableMap.builder().put((Object)"totalInit", (Object)vm.totalInit()).put((Object)"totalUsed", (Object)vm.totalUsed()).put((Object)"totalMax", (Object)vm.totalMax()).put((Object)"totalCommitted", (Object)vm.totalCommitted()).put((Object)"heapInit", (Object)vm.heapInit()).put((Object)"heapUsed", (Object)vm.heapUsed()).put((Object)"heapMax", (Object)vm.heapMax()).put((Object)"heapCommitted", (Object)vm.heapCommitted()).put((Object)"heap_usage", (Object)vm.heapUsage()).put((Object)"non_heap_usage", (Object)vm.nonHeapUsage()).build();
    }

    public static Map<String, Double> memoryPoolsMetrics(VirtualMachineMetrics vm) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry pool : vm.memoryPoolUsage().entrySet()) {
            builder.put(pool.getKey(), pool.getValue());
        }
        return builder.build();
    }

    public static Map<String, Double> buffersMetrics(VirtualMachineMetrics.BufferPoolStats bps) {
        return ImmutableMap.builder().put((Object)"count", (Object)bps.getCount()).put((Object)"memoryUsed", (Object)bps.getMemoryUsed()).put((Object)"totalCapacity", (Object)bps.getTotalCapacity()).build();
    }

    public static Map<String, Double> vmMetrics(VirtualMachineMetrics vm) {
        return ImmutableMap.builder().put((Object)"daemon_thread_count", (Object)vm.daemonThreadCount()).put((Object)"thread_count", (Object)vm.threadCount()).put((Object)"uptime", (Object)vm.uptime()).put((Object)"fd_usage", (Object)vm.fileDescriptorUsage()).build();
    }

    public static Map<String, Double> threadStateMetrics(VirtualMachineMetrics vm) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : vm.threadStatePercentages().entrySet()) {
            builder.put((Object)((Thread.State)((Object)entry.getKey())).toString().toLowerCase(), entry.getValue());
        }
        return builder.build();
    }

    public static Map<String, Double> gcMetrics(VirtualMachineMetrics.GarbageCollectorStats gcs) {
        return ImmutableMap.builder().put((Object)"runs", (Object)gcs.getRuns()).put((Object)"time", (Object)gcs.getTime(TimeUnit.MILLISECONDS)).build();
    }

    public static String sanitize(String name) {
        return SIMPLE_NAMES.matcher(name).replaceAll("_");
    }

    public static String sanitize(MetricName metricName) {
        return MetricsToTimeseries.sanitize(metricName.getGroup() + "." + metricName.getName());
    }

    public static double sanitizeValue(double value, boolean convertNanToZero) {
        return Double.isNaN(value) && convertNanToZero ? 0.0 : value;
    }
}

