/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.SocketFactory;

public class ReconnectingSocket {
    protected static final Logger logger = Logger.getLogger(ReconnectingSocket.class.getCanonicalName());
    private static final int SERVER_READ_TIMEOUT_MILLIS = 2000;
    private static final int SERVER_POLL_INTERVAL_MILLIS = 4000;
    private final String host;
    private final int port;
    private final long connectionTimeToLiveMillis;
    private final Supplier<Long> timeSupplier;
    private final SocketFactory socketFactory;
    private volatile boolean serverTerminated;
    private volatile long lastConnectionTimeMillis;
    private final Timer pollingTimer;
    private AtomicReference<Socket> underlyingSocket;
    private AtomicReference<BufferedOutputStream> socketOutputStream;

    public ReconnectingSocket(String host, int port, SocketFactory socketFactory) throws IOException {
        this(host, port, socketFactory, null, null);
    }

    public ReconnectingSocket(String host, int port, SocketFactory socketFactory, @Nullable Long connectionTimeToLiveMillis, @Nullable Supplier<Long> timeSupplier) throws IOException {
        this.host = host;
        this.port = port;
        this.serverTerminated = false;
        this.socketFactory = socketFactory;
        this.connectionTimeToLiveMillis = connectionTimeToLiveMillis == null ? Long.MAX_VALUE : connectionTimeToLiveMillis;
        this.timeSupplier = timeSupplier == null ? System::currentTimeMillis : timeSupplier;
        this.underlyingSocket = new AtomicReference<Socket>(socketFactory.createSocket(host, port));
        this.underlyingSocket.get().setSoTimeout(2000);
        this.socketOutputStream = new AtomicReference<BufferedOutputStream>(new BufferedOutputStream(this.underlyingSocket.get().getOutputStream()));
        this.lastConnectionTimeMillis = this.timeSupplier.get();
        this.pollingTimer = new Timer();
        this.pollingTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                ReconnectingSocket.this.maybeReconnect();
            }
        }, 4000L, 4000L);
    }

    @VisibleForTesting
    void maybeReconnect() {
        try {
            int bytesRead;
            byte[] message = new byte[1000];
            try {
                bytesRead = this.underlyingSocket.get().getInputStream().read(message);
            }
            catch (IOException e) {
                return;
            }
            if (bytesRead == -1) {
                this.serverTerminated = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cannot poll server for TCP FIN.");
        }
    }

    public ReconnectingSocket(String host, int port) throws IOException {
        this(host, port, SocketFactory.getDefault());
    }

    /*
     * Loose catch block
     */
    private synchronized void resetSocket() throws IOException {
        block11: {
            BufferedOutputStream old = this.socketOutputStream.get();
            if (old != null) {
                old.close();
            }
            this.serverTerminated = false;
            try {
                this.underlyingSocket.getAndSet(this.socketFactory.createSocket(this.host, this.port)).close();
            }
            catch (SocketException e) {
                logger.log(Level.WARNING, "Could not close old socket.", e);
            }
            this.underlyingSocket.get().setSoTimeout(2000);
            this.socketOutputStream.set(new BufferedOutputStream(this.underlyingSocket.get().getOutputStream()));
            this.lastConnectionTimeMillis = this.timeSupplier.get();
            logger.log(Level.INFO, String.format("Successfully reset connection to %s:%d", this.host, this.port));
            break block11;
            catch (SocketException e) {
                try {
                    logger.log(Level.INFO, "Could not flush to socket.", e);
                    this.serverTerminated = false;
                }
                catch (Throwable throwable) {
                    this.serverTerminated = false;
                    try {
                        this.underlyingSocket.getAndSet(this.socketFactory.createSocket(this.host, this.port)).close();
                    }
                    catch (SocketException e2) {
                        logger.log(Level.WARNING, "Could not close old socket.", e2);
                    }
                    this.underlyingSocket.get().setSoTimeout(2000);
                    this.socketOutputStream.set(new BufferedOutputStream(this.underlyingSocket.get().getOutputStream()));
                    this.lastConnectionTimeMillis = this.timeSupplier.get();
                    logger.log(Level.INFO, String.format("Successfully reset connection to %s:%d", this.host, this.port));
                    throw throwable;
                }
                try {
                    this.underlyingSocket.getAndSet(this.socketFactory.createSocket(this.host, this.port)).close();
                }
                catch (SocketException e3) {
                    logger.log(Level.WARNING, "Could not close old socket.", e3);
                }
                this.underlyingSocket.get().setSoTimeout(2000);
                this.socketOutputStream.set(new BufferedOutputStream(this.underlyingSocket.get().getOutputStream()));
                this.lastConnectionTimeMillis = this.timeSupplier.get();
                logger.log(Level.INFO, String.format("Successfully reset connection to %s:%d", this.host, this.port));
            }
        }
    }

    public void write(String message) throws Exception {
        try {
            if (this.serverTerminated) {
                throw new Exception("Remote server terminated.");
            }
            this.socketOutputStream.get().write(message.getBytes());
        }
        catch (Exception e) {
            try {
                logger.log(Level.WARNING, "Attempting to reset socket connection.", e);
                this.resetSocket();
                this.socketOutputStream.get().write(message.getBytes());
            }
            catch (Exception e2) {
                throw Throwables.propagate((Throwable)e2);
            }
        }
    }

    public synchronized void flush() throws IOException {
        try {
            this.socketOutputStream.get().flush();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Attempting to reset socket connection.", e);
            this.resetSocket();
        }
        if (this.timeSupplier.get() - this.lastConnectionTimeMillis > this.connectionTimeToLiveMillis) {
            logger.info("Connection TTL expired, reconnecting");
            this.resetSocket();
        }
    }

    public void close() throws IOException {
        try {
            this.flush();
        }
        finally {
            this.pollingTimer.cancel();
            this.socketOutputStream.get().close();
        }
    }
}

