/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.util.function.Function;
import java.util.logging.Logger;
import wavefront.report.SpanLog;
import wavefront.report.SpanLogs;

public class SpanLogsSerializer
implements Function<SpanLogs, String> {
    private static final Logger logger = Logger.getLogger(SpanLogsSerializer.class.getCanonicalName());
    private static final ObjectMapper JSON_PARSER = new ObjectMapper();

    @Override
    public String apply(SpanLogs spanLogs) {
        return SpanLogsSerializer.spanLogsToString(spanLogs);
    }

    @VisibleForTesting
    static String spanLogsToString(SpanLogs spanLogs) {
        try {
            return JSON_PARSER.writeValueAsString((Object)spanLogs);
        }
        catch (JsonProcessingException e) {
            logger.warning("Serialization error!");
            return null;
        }
    }

    static {
        JSON_PARSER.addMixIn(SpanLogs.class, IgnoreSchemaProperty.class);
        JSON_PARSER.addMixIn(SpanLog.class, IgnoreSchemaProperty.class);
    }

    static abstract class IgnoreSchemaProperty {
        IgnoreSchemaProperty() {
        }

        @JsonIgnore
        abstract void getSchema();
    }
}

