/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StringParser {
    private static final String EQ_TOKEN = "=";
    private static final String WEIGHT_TOKEN = "#";
    private int currentIndex = 0;
    private final String input;
    private String peek = null;

    public StringParser(@Nonnull String input) {
        Preconditions.checkNotNull((Object)input);
        this.input = input;
        this.currentIndex = 0;
    }

    @Nullable
    public String peek() {
        if (this.peek == null) {
            this.peek = this.advance();
        }
        return this.peek;
    }

    public boolean hasNext() {
        return this.peek() != null;
    }

    @Nullable
    public String next() {
        String token = this.peek();
        this.peek = null;
        return token;
    }

    @Nullable
    private String advance() {
        while (this.currentIndex < this.input.length() && Character.isWhitespace(this.input.charAt(this.currentIndex))) {
            ++this.currentIndex;
        }
        if (this.currentIndex >= this.input.length()) {
            return null;
        }
        char currentChar = this.input.charAt(this.currentIndex);
        ++this.currentIndex;
        if (currentChar == '\"' || currentChar == '\'') {
            return this.parseAsQuoted(currentChar);
        }
        if (currentChar == '=') {
            return EQ_TOKEN;
        }
        if (currentChar == '#') {
            return WEIGHT_TOKEN;
        }
        return this.parseAsNonQuoted();
    }

    private String parseAsQuoted(char quoteChar) {
        int index = this.input.indexOf(quoteChar, this.currentIndex);
        if (index == -1) {
            throw new RuntimeException("Unmatched quote character: (" + quoteChar + ")");
        }
        int startIndex = this.currentIndex;
        this.currentIndex = index + 1;
        if (this.input.charAt(index - 1) != '\\') {
            return this.input.substring(startIndex, index);
        }
        StringBuilder unquoted = new StringBuilder(index - startIndex + 16);
        boolean escapedQuote = true;
        while (escapedQuote) {
            unquoted.append(this.input, startIndex, index - 1);
            unquoted.append(quoteChar);
            index = this.input.indexOf(quoteChar, this.currentIndex);
            startIndex = this.currentIndex;
            this.currentIndex = index + 1;
            if (index == -1) {
                throw new RuntimeException("Unmatched quote character: (" + quoteChar + ")");
            }
            escapedQuote = this.input.charAt(index - 1) == '\\';
        }
        return unquoted.append(this.input, startIndex, index).toString();
    }

    private String parseAsNonQuoted() {
        int indexOfSeparator = StringParser.indexOfAnySeparator(this.input, this.currentIndex);
        int endOfToken = indexOfSeparator == -1 ? this.input.length() : indexOfSeparator;
        String result = this.input.substring(this.currentIndex - 1, endOfToken);
        this.currentIndex = endOfToken;
        return result;
    }

    private static int indexOfAnySeparator(String input, int startIndex) {
        for (int i = startIndex; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ch != ' ' && ch != '=' && ch != '\t') continue;
            return i;
        }
        return -1;
    }
}

