/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.util.concurrent.RecyclableRateLimiter;
import com.wavefront.common.LazySupplier;
import com.wavefront.common.TaggedMetricName;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class RecyclableRateLimiterWithMetrics
implements RecyclableRateLimiter {
    private final RecyclableRateLimiter delegate;
    private final Supplier<RateLimiterMetricsContainer> metrics;

    public RecyclableRateLimiterWithMetrics(RecyclableRateLimiter delegate, String prefix) {
        this(delegate, LazySupplier.of(() -> new RateLimiterMetricsContainer(Metrics.newCounter((MetricName)new TaggedMetricName(prefix, "permits-granted")), Metrics.newCounter((MetricName)new TaggedMetricName(prefix, "permits-denied")), Metrics.newCounter((MetricName)new TaggedMetricName(prefix, "permits-retried")))));
    }

    public RecyclableRateLimiterWithMetrics(RecyclableRateLimiter delegate, Supplier<RateLimiterMetricsContainer> metrics) {
        this.delegate = delegate;
        this.metrics = metrics;
    }

    @Override
    public double getRate() {
        return this.delegate.getRate();
    }

    @Override
    public void setRate(double rate) {
        this.delegate.setRate(rate);
    }

    @Override
    public double acquire(int permits) {
        double result = this.delegate.acquire(permits);
        Counter granted = this.metrics.get().permitsGrantedCounter;
        if (granted != null) {
            granted.inc((long)permits);
        }
        return result;
    }

    @Override
    public boolean tryAcquire(int permits) {
        if (this.delegate.tryAcquire(permits)) {
            Counter granted = this.metrics.get().permitsGrantedCounter;
            if (granted != null) {
                granted.inc((long)permits);
            }
            return true;
        }
        Counter denied = this.metrics.get().permitsDeniedCounter;
        if (denied != null) {
            denied.inc((long)permits);
        }
        return false;
    }

    @Override
    public void recyclePermits(int permits) {
        this.delegate.recyclePermits(permits);
        Counter recycled = this.metrics.get().permitsRecycledCounter;
        if (recycled != null) {
            recycled.inc((long)permits);
        }
    }

    @Override
    public boolean immediatelyAvailable(int permits) {
        return this.delegate.immediatelyAvailable(permits);
    }

    public static class RateLimiterMetricsContainer {
        private Counter permitsGrantedCounter;
        private Counter permitsDeniedCounter;
        private Counter permitsRecycledCounter;

        private RateLimiterMetricsContainer(@Nullable Counter permitsGrantedCounter, @Nullable Counter permitsDeniedCounter, @Nullable Counter permitsRecycledCounter) {
            this.permitsGrantedCounter = permitsGrantedCounter;
            this.permitsDeniedCounter = permitsDeniedCounter;
            this.permitsRecycledCounter = permitsRecycledCounter;
        }
    }
}

