/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.StringParser;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import wavefront.report.ReportSourceTag;
import wavefront.report.SourceOperationType;
import wavefront.report.SourceTagAction;

public class ReportSourceTagIngesterFormatter
extends AbstractIngesterFormatter<ReportSourceTag> {
    private ReportSourceTagIngesterFormatter(List<AbstractIngesterFormatter.FormatterElement<ReportSourceTag>> elements) {
        super(elements);
    }

    public static SourceTagIngesterFormatBuilder newBuilder() {
        return new SourceTagIngesterFormatBuilder();
    }

    @Override
    public ReportSourceTag drive(String input, @Nullable Supplier<String> defaultHostNameSupplier, String customerId, List<String> customerSourceTags) {
        ReportSourceTag sourceTag = new ReportSourceTag();
        StringParser parser = new StringParser(input);
        try {
            for (AbstractIngesterFormatter.FormatterElement element : this.elements) {
                element.consume(parser, sourceTag);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not parse: " + input, ex);
        }
        if (sourceTag.getAnnotations() == null || sourceTag.getAnnotations().isEmpty()) {
            if (sourceTag.getOperation() != SourceOperationType.SOURCE_DESCRIPTION || sourceTag.getAction() != SourceTagAction.DELETE) {
                throw new IllegalArgumentException("No data provided for operation `" + (Object)((Object)sourceTag.getOperation()) + "` action: " + (Object)((Object)sourceTag.getAction()));
            }
        } else if (sourceTag.getOperation() == SourceOperationType.SOURCE_DESCRIPTION && sourceTag.getAnnotations().size() > 1) {
            throw new IllegalArgumentException("Only one description expected");
        }
        return sourceTag;
    }

    public static class SourceTagIngesterFormatBuilder
    extends AbstractIngesterFormatter.IngesterFormatBuilder<ReportSourceTag> {
        public ReportSourceTagIngesterFormatter build() {
            return new ReportSourceTagIngesterFormatter(this.elements);
        }
    }
}

