/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tdunning.math.stats.AVLTreeDigest;
import com.tdunning.math.stats.Centroid;
import com.wavefront.ingester.IngesterContext;
import com.wavefront.ingester.StringParser;
import com.wavefront.ingester.TooManyCentroidException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.commons.lang.StringUtils;
import wavefront.report.Annotation;
import wavefront.report.Histogram;

public abstract class AbstractIngesterFormatter<T extends SpecificRecordBase> {
    public static final String SOURCE_TAG_LITERAL = "@SourceTag";
    public static final String SOURCE_DESCRIPTION_LITERAL = "@SourceDescription";
    public static final String EVENT_LITERAL = "@Event";
    private static final String SINGLE_QUOTE_STR = "'";
    private static final String ESCAPED_SINGLE_QUOTE_STR = "\\'";
    private static final String DOUBLE_QUOTE_STR = "\"";
    private static final String ESCAPED_DOUBLE_QUOTE_STR = "\\\"";
    private static final IngesterContext DEFAULT_INGESTER_CONTEXT = new IngesterContext.Builder().build();
    protected final List<FormatterElement<T>> elements;

    protected AbstractIngesterFormatter(List<FormatterElement<T>> elements) {
        this.elements = elements;
    }

    public static void optimizeForStorage(@Nullable List<Double> means, @Nullable List<Integer> counts, int size, int storageAccuracy) {
        if (means == null || means.isEmpty() || counts == null || counts.isEmpty()) {
            return;
        }
        if ((double)size > 2.0 * (double)storageAccuracy) {
            AbstractIngesterFormatter.rewrite(means, counts, size, storageAccuracy);
        }
        if (counts.stream().anyMatch(i -> i < 1)) {
            AbstractIngesterFormatter.rewrite(means, counts, size, storageAccuracy);
        } else {
            int strictlyIncreasingLength;
            for (strictlyIncreasingLength = 1; strictlyIncreasingLength < means.size() && !(means.get(strictlyIncreasingLength - 1) >= means.get(strictlyIncreasingLength)); ++strictlyIncreasingLength) {
            }
            if (strictlyIncreasingLength != means.size()) {
                AbstractIngesterFormatter.rewrite(means, counts, size, storageAccuracy);
            }
        }
    }

    private static void rewrite(List<Double> means, List<Integer> counts, int size, int storageAccuracy) {
        AVLTreeDigest temp = new AVLTreeDigest((double)storageAccuracy);
        for (int i = 0; i < size; ++i) {
            int count = counts.get(i);
            if (count <= 0) continue;
            temp.add(means.get(i).doubleValue(), count);
        }
        temp.compress();
        means.clear();
        counts.clear();
        for (Centroid c : temp.centroids()) {
            means.add(c.mean());
            counts.add(c.count());
        }
    }

    private static Long parseTimestamp(StringParser parser, boolean optional, boolean raw) {
        String peek = parser.peek();
        if (peek == null || !Character.isDigit(peek.charAt(0))) {
            if (optional) {
                return null;
            }
            throw new RuntimeException("Expected timestamp, found " + (peek == null ? "end of line" : peek));
        }
        try {
            Double timestamp = Double.parseDouble(peek);
            long timestampLong = timestamp.longValue();
            parser.next();
            if (raw) {
                return timestampLong;
            }
            if (timestampLong < 1000000000000L) {
                return (long)(1000.0 * timestamp);
            }
            if (timestampLong < 10000000000000L) {
                return timestampLong;
            }
            if (timestampLong < 10000000000000000L) {
                return timestampLong / 1000L;
            }
            return timestampLong / 1000000L;
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Invalid timestamp value: " + peek);
        }
    }

    private static void parseKeyValuePair(StringParser parser, BiConsumer<String, String> kvConsumer) {
        String annotationKey = parser.next();
        String op = parser.next();
        if (op == null) {
            throw new RuntimeException("Tag keys and values must be separated by '=', nothing found after '" + annotationKey + SINGLE_QUOTE_STR);
        }
        if (!op.equals("=")) {
            throw new RuntimeException("Tag keys and values must be separated by '=', found " + op);
        }
        String annotationValue = parser.next();
        if (annotationValue == null) {
            throw new RuntimeException("Value missing for " + annotationKey);
        }
        kvConsumer.accept(annotationKey, annotationValue);
    }

    public static String unquote(String text) {
        if (text.startsWith(DOUBLE_QUOTE_STR)) {
            String quoteless = text.substring(1, text.length() - 1);
            if (StringUtils.containsAny((String)quoteless, (String)ESCAPED_DOUBLE_QUOTE_STR)) {
                return StringUtils.replace((String)quoteless, (String)ESCAPED_DOUBLE_QUOTE_STR, (String)DOUBLE_QUOTE_STR);
            }
            return quoteless;
        }
        if (text.startsWith(SINGLE_QUOTE_STR)) {
            String quoteless = text.substring(1, text.length() - 1);
            if (StringUtils.containsAny((String)quoteless, (String)ESCAPED_SINGLE_QUOTE_STR)) {
                return StringUtils.replace((String)quoteless, (String)ESCAPED_SINGLE_QUOTE_STR, (String)SINGLE_QUOTE_STR);
            }
            return quoteless;
        }
        return text;
    }

    public T drive(String input, @Nullable Supplier<String> defaultHostNameSupplier, String customerId) {
        return this.drive(input, defaultHostNameSupplier, customerId, null, null);
    }

    public T drive(String input, @Nullable Supplier<String> defaultHostNameSupplier, String customerId, IngesterContext ingesterContext) {
        return this.drive(input, defaultHostNameSupplier, customerId, null, ingesterContext);
    }

    public abstract T drive(String var1, @Nullable Supplier<String> var2, String var3, @Nullable List<String> var4, @Nullable IngesterContext var5);

    public static class AnnotationList<T extends SpecificRecordBase>
    implements FormatterElement<T> {
        private final BiConsumer<T, List<Annotation>> annotationListConsumer;
        private final Predicate<String> predicate;

        AnnotationList(BiConsumer<T, List<Annotation>> annotationListConsumer, Predicate<String> predicate) {
            this.annotationListConsumer = annotationListConsumer;
            this.predicate = predicate;
        }

        @Override
        public void consume(StringParser parser, T target, IngesterContext ingesterContext) {
            ArrayList annotationList = new ArrayList();
            while (parser.hasNext() && this.predicate.test(parser.peek())) {
                AbstractIngesterFormatter.parseKeyValuePair(parser, (k, v) -> annotationList.add(new Annotation((String)k, (String)v)));
            }
            this.annotationListConsumer.accept(target, annotationList);
        }
    }

    public static class StringMultiMap<T extends SpecificRecordBase>
    implements FormatterElement<T> {
        private final BiConsumer<T, Map<String, List<String>>> annotationMultimapConsumer;

        StringMultiMap(BiConsumer<T, Map<String, List<String>>> annotationMultimapConsumer) {
            this.annotationMultimapConsumer = annotationMultimapConsumer;
        }

        @Override
        public void consume(StringParser parser, T target, IngesterContext ingesterContext) {
            HashMap multimap = new HashMap();
            while (parser.hasNext()) {
                AbstractIngesterFormatter.parseKeyValuePair(parser, (k, v) -> multimap.computeIfAbsent(k, x -> new ArrayList()).add(v));
            }
            this.annotationMultimapConsumer.accept(target, multimap);
        }
    }

    public static class StringMap<T extends SpecificRecordBase>
    implements FormatterElement<T> {
        private final BiConsumer<T, Map<String, String>> stringMapConsumer;
        private final Function<T, Map<String, String>> stringMapProvider;
        private final Integer limit;
        private final Predicate<String> predicate;

        StringMap(BiConsumer<T, Map<String, String>> stringMapConsumer) {
            this(stringMapConsumer, null, null, null);
        }

        StringMap(BiConsumer<T, Map<String, String>> stringMapConsumer, @Nullable Function<T, Map<String, String>> stringMapProvider, @Nullable Integer limit, @Nullable Predicate<String> predicate) {
            this.stringMapConsumer = stringMapConsumer;
            this.stringMapProvider = stringMapProvider;
            this.limit = limit;
            this.predicate = predicate;
        }

        @Override
        public void consume(StringParser parser, T target, IngesterContext ingesterContext) {
            Map<Object, Object> stringMap = null;
            if (this.stringMapProvider != null) {
                stringMap = this.stringMapProvider.apply(target);
            }
            if (stringMap == null) {
                stringMap = Maps.newHashMap();
            }
            for (int i = 0; parser.hasNext() && (this.limit == null || i < this.limit); ++i) {
                if (this.predicate != null) {
                    if (!this.predicate.test(parser.peek())) break;
                }
                AbstractIngesterFormatter.parseKeyValuePair(parser, stringMap::put);
            }
            this.stringMapConsumer.accept(target, stringMap);
        }
    }

    public static class StringList<T extends SpecificRecordBase>
    implements FormatterElement<T> {
        private final BiConsumer<T, List<String>> stringListConsumer;

        StringList(BiConsumer<T, List<String>> stringListConsumer) {
            this.stringListConsumer = stringListConsumer;
        }

        @Override
        public void consume(StringParser parser, T target, IngesterContext ingesterContext) {
            ArrayList<String> list = new ArrayList<String>();
            while (parser.hasNext()) {
                list.add(parser.next());
            }
            this.stringListConsumer.accept(target, list);
        }
    }

    public static class Timestamp<T extends SpecificRecordBase>
    implements FormatterElement<T> {
        private final BiConsumer<T, Long> timestampConsumer;
        private final boolean optional;
        private final boolean raw;

        Timestamp(BiConsumer<T, Long> timestampConsumer, boolean optional, boolean raw) {
            this.timestampConsumer = timestampConsumer;
            this.optional = optional;
            this.raw = raw;
        }

        @Override
        public void consume(StringParser parser, T target, IngesterContext ingesterContext) {
            Long timestamp = AbstractIngesterFormatter.parseTimestamp(parser, this.optional, this.raw);
            if (timestamp != null) {
                this.timestampConsumer.accept(target, timestamp);
            }
        }
    }

    public static class Centroids<T extends SpecificRecordBase>
    implements FormatterElement<T> {
        private static final String WEIGHT = "#";

        @Override
        public void consume(StringParser parser, T target, IngesterContext ingesterContext) {
            ArrayList<Integer> counts = new ArrayList<Integer>();
            ArrayList<Double> bins = new ArrayList<Double>();
            int size = 0;
            while (WEIGHT.equals(parser.peek())) {
                if (++size > ingesterContext.getHistogramCentroidsLimit()) {
                    throw new TooManyCentroidException();
                }
                parser.next();
                counts.add(Centroids.parse(parser.next(), "centroid weight", true).intValue());
                bins.add(Centroids.parse(parser.next(), "centroid value", false).doubleValue());
            }
            if (size == 0) {
                throw new RuntimeException("Empty histogram (no centroids)");
            }
            AbstractIngesterFormatter.optimizeForStorage(bins, counts, size, ingesterContext.getTargetHistogramAccuracy());
            Histogram histogram = (Histogram)((Object)target.get("value"));
            histogram.setCounts(counts);
            histogram.setBins(bins);
        }

        private static Number parse(@Nullable String toParse, String name, boolean asInteger) {
            if (toParse == null) {
                throw new RuntimeException("Unexpected end of line, expected: " + name);
            }
            try {
                return asInteger ? (double)Integer.parseInt(toParse) : Double.parseDouble(toParse);
            }
            catch (NumberFormatException nef) {
                throw new RuntimeException("Expected: " + name + ", got: " + toParse);
            }
        }
    }

    public static class Value<T extends SpecificRecordBase>
    implements FormatterElement<T> {
        final BiConsumer<T, Double> valueConsumer;

        Value(BiConsumer<T, Double> valueConsumer) {
            this.valueConsumer = valueConsumer;
        }

        @Override
        public void consume(StringParser parser, T target, IngesterContext ingesterContext) {
            String token = parser.next();
            if (token == null) {
                throw new RuntimeException("Value is missing");
            }
            try {
                this.valueConsumer.accept(target, Double.parseDouble(token));
            }
            catch (NumberFormatException nef) {
                throw new RuntimeException("Invalid value: " + token);
            }
        }
    }

    public static class Text<T extends SpecificRecordBase>
    implements FormatterElement<T> {
        final List<String> literals;
        final BiConsumer<T, String> textConsumer;
        final boolean isCaseSensitive;

        Text(@Nullable BiConsumer<T, String> textConsumer) {
            this(null, textConsumer, true);
        }

        Text(List<String> literals, @Nullable BiConsumer<T, String> textConsumer, boolean isCaseSensitive) {
            this.literals = literals;
            this.textConsumer = textConsumer;
            this.isCaseSensitive = isCaseSensitive;
        }

        @Override
        public void consume(StringParser parser, T target, IngesterContext ingesterContext) {
            String text = parser.next();
            if (!this.isAllowedLiteral(text)) {
                throw new RuntimeException(AbstractIngesterFormatter.SINGLE_QUOTE_STR + text + "' is not allowed here!");
            }
            if (this.textConsumer != null) {
                this.textConsumer.accept(target, text);
            }
        }

        private boolean isAllowedLiteral(String literal) {
            if (this.literals == null) {
                return true;
            }
            for (String allowedLiteral : this.literals) {
                if (this.isCaseSensitive && literal.equals(allowedLiteral)) {
                    return true;
                }
                if (this.isCaseSensitive || !literal.equalsIgnoreCase(allowedLiteral)) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class IngesterFormatBuilder<T extends SpecificRecordBase> {
        final List<FormatterElement<T>> elements = Lists.newArrayList();

        public IngesterFormatBuilder<T> caseSensitiveLiterals(List<String> literals) {
            this.elements.add(new Text(literals, null, true));
            return this;
        }

        public IngesterFormatBuilder<T> caseSensitiveLiterals(List<String> literals, BiConsumer<T, String> textConsumer) {
            this.elements.add(new Text<T>(literals, textConsumer, true));
            return this;
        }

        public IngesterFormatBuilder<T> caseInsensitiveLiterals(List<String> literals) {
            this.elements.add(new Text(literals, null, false));
            return this;
        }

        public IngesterFormatBuilder<T> text(BiConsumer<T, String> textConsumer) {
            this.elements.add(new Text<T>(textConsumer));
            return this;
        }

        public IngesterFormatBuilder<T> value(BiConsumer<T, Double> valueConsumer) {
            this.elements.add(new Value<T>(valueConsumer));
            return this;
        }

        public IngesterFormatBuilder<T> centroids() {
            this.elements.add(new Centroids());
            return this;
        }

        public IngesterFormatBuilder<T> timestamp(BiConsumer<T, Long> timestampConsumer) {
            this.elements.add(new Timestamp<T>(timestampConsumer, false, false));
            return this;
        }

        public IngesterFormatBuilder<T> optionalTimestamp(BiConsumer<T, Long> timestampConsumer) {
            this.elements.add(new Timestamp<T>(timestampConsumer, true, false));
            return this;
        }

        public IngesterFormatBuilder<T> rawTimestamp(BiConsumer<T, Long> timestampConsumer) {
            this.elements.add(new Timestamp<T>(timestampConsumer, false, true));
            return this;
        }

        public IngesterFormatBuilder<T> annotationMap(BiConsumer<T, Map<String, String>> mapConsumer) {
            this.elements.add(new StringMap<T>(mapConsumer));
            return this;
        }

        public IngesterFormatBuilder<T> annotationMap(Function<T, Map<String, String>> mapProvider, BiConsumer<T, Map<String, String>> mapConsumer) {
            this.elements.add(new StringMap<T>(mapConsumer, mapProvider, null, null));
            return this;
        }

        public IngesterFormatBuilder<T> annotationMap(BiConsumer<T, Map<String, String>> mapConsumer, int limit) {
            this.elements.add(new StringMap<T>(mapConsumer, null, limit, null));
            return this;
        }

        public IngesterFormatBuilder<T> annotationList(BiConsumer<T, List<Annotation>> listConsumer) {
            this.elements.add(new AnnotationList<T>(listConsumer, x -> !StringUtils.isNumeric((String)x)));
            return this;
        }

        public IngesterFormatBuilder<T> annotationMultimap(BiConsumer<T, Map<String, List<String>>> multimapConsumer) {
            this.elements.add(new StringMultiMap<T>(multimapConsumer));
            return this;
        }

        public IngesterFormatBuilder<T> textList(BiConsumer<T, List<String>> listConsumer) {
            this.elements.add(new StringList<T>(listConsumer));
            return this;
        }

        public abstract AbstractIngesterFormatter<T> build();
    }

    protected static interface FormatterElement<T> {
        default public void consume(StringParser parser, T target) {
            this.consume(parser, target, DEFAULT_INGESTER_CONTEXT);
        }

        public void consume(StringParser var1, T var2, IngesterContext var3);
    }
}

