/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.wavefront.ingester.Decoder;
import com.wavefront.ingester.IngesterContext;
import com.wavefront.ingester.ReportPointDecoder;
import com.wavefront.ingester.ReportableEntityDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import wavefront.report.ReportPoint;

public class GraphiteDecoder
implements Decoder<String> {
    private static final Pattern CUSTOMERID = Pattern.compile("[a-z]+");
    private final ReportableEntityDecoder<String, ReportPoint> pointDecoder;

    public GraphiteDecoder(List<String> customSourceTags) {
        this("unknown", customSourceTags);
    }

    public GraphiteDecoder(String hostName, List<String> customSourceTags) {
        this(() -> hostName, customSourceTags);
    }

    public GraphiteDecoder(@Nullable Supplier<String> hostNameSupplier, List<String> customSourceTags) {
        this.pointDecoder = new ReportPointDecoder(hostNameSupplier, customSourceTags);
    }

    @Override
    public void decodeReportPoints(String msg, List<ReportPoint> out, String customerId) {
        this.pointDecoder.decode(msg, out, customerId);
    }

    @Override
    public void decodeReportPoints(String msg, List<ReportPoint> out, String customerId, IngesterContext ingesterContext) {
        this.pointDecoder.decode(msg, out, customerId);
    }

    @Override
    public void decodeReportPoints(String msg, List<ReportPoint> out) {
        ArrayList output = Lists.newArrayList();
        this.decodeReportPoints(msg, (List<ReportPoint>)output, "dummy");
        if (!output.isEmpty()) {
            for (ReportPoint rp : output) {
                String metricName = rp.getMetric();
                ArrayList metricParts = Lists.newArrayList((Iterable)Splitter.on((String)".").split((CharSequence)metricName));
                if (metricParts.size() <= 1) {
                    throw new RuntimeException("Metric name does not contain a customer id: " + metricName);
                }
                String customerId = (String)metricParts.get(0);
                if (CUSTOMERID.matcher(customerId).matches()) {
                    metricName = Joiner.on((String)".").join(metricParts.subList(1, metricParts.size()));
                }
                out.add(ReportPoint.newBuilder(rp).setMetric(metricName).setTable(customerId).build());
            }
        }
    }
}

