/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.google.common.collect.ImmutableList;
import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.Decoder;
import com.wavefront.ingester.IngesterContext;
import com.wavefront.ingester.ReportPointIngesterFormatter;
import java.util.List;
import java.util.function.Supplier;
import wavefront.report.Histogram;
import wavefront.report.HistogramType;
import wavefront.report.ReportPoint;

public class HistogramDecoder
implements Decoder<String> {
    private static final AbstractIngesterFormatter<ReportPoint> FORMAT = ReportPointIngesterFormatter.newBuilder().caseSensitiveLiterals((List<String>)ImmutableList.of((Object)"!M", (Object)"!H", (Object)"!D"), HistogramDecoder::setBinType).optionalTimestamp(ReportPoint::setTimestamp).centroids().text(ReportPoint::setMetric).annotationMap(ReportPoint::setAnnotations).build();
    private final Supplier<String> defaultHostNameSupplier;

    public HistogramDecoder() {
        this("unknown");
    }

    public HistogramDecoder(String defaultHostName) {
        this(() -> defaultHostName);
    }

    public HistogramDecoder(Supplier<String> defaultHostNameSupplier) {
        this.defaultHostNameSupplier = defaultHostNameSupplier;
    }

    @Override
    public void decodeReportPoints(String msg, List<ReportPoint> out, String customerId) {
        ReportPoint point = FORMAT.drive(msg, this.defaultHostNameSupplier, customerId);
        if (point != null) {
            long duration = ((Histogram)((Object)point.getValue())).getDuration();
            point.setTimestamp(point.getTimestamp() / duration * duration);
            out.add(ReportPoint.newBuilder(point).build());
        }
    }

    @Override
    public void decodeReportPoints(String msg, List<ReportPoint> out, String customerId, IngesterContext ingesterContext) {
        ReportPoint point = FORMAT.drive(msg, this.defaultHostNameSupplier, customerId, ingesterContext);
        if (point != null) {
            long duration = ((Histogram)((Object)point.getValue())).getDuration();
            point.setTimestamp(point.getTimestamp() / duration * duration);
            out.add(ReportPoint.newBuilder(point).build());
        }
    }

    @Override
    public void decodeReportPoints(String msg, List<ReportPoint> out) {
        throw new UnsupportedOperationException("Customer ID extraction is not supported");
    }

    private static void setBinType(ReportPoint target, String binType) {
        int durationMillis;
        switch (binType) {
            case "!M": {
                durationMillis = 60000;
                break;
            }
            case "!H": {
                durationMillis = 3600000;
                break;
            }
            case "!D": {
                durationMillis = 86400000;
                break;
            }
            default: {
                throw new RuntimeException("Unknown BinType " + binType);
            }
        }
        Histogram histogram = new Histogram();
        histogram.setDuration(durationMillis);
        histogram.setType(HistogramType.TDIGEST);
        target.setValue(histogram);
    }
}

