/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

public class IngesterContext {
    public static final double DEFAULT_HISTOGRAM_COMPRESS_LIMIT_RATIO = 2.0;
    public static final int DEFAULT_CENTROIDS_COUNT_LIMIT = 100;
    public static final int DEFAULT_HISTOGRAM_ACCURACY = 32;
    private int histogramCentroidsLimit;
    private int targetHistogramAccuracy;

    private IngesterContext(Builder builder) {
        this.histogramCentroidsLimit = builder.histogramCentroidsLimit;
        this.targetHistogramAccuracy = builder.targetHistogramAccuracy;
    }

    public void reset() {
        this.histogramCentroidsLimit = 100;
        this.targetHistogramAccuracy = 32;
    }

    public int getHistogramCentroidsLimit() {
        return this.histogramCentroidsLimit;
    }

    public void setHistogramCentroidsLimit(int histogramCentroidsLimit) {
        this.histogramCentroidsLimit = histogramCentroidsLimit;
    }

    public int getTargetHistogramAccuracy() {
        return this.targetHistogramAccuracy;
    }

    public void setTargetHistogramAccuracy(int targetHistogramAccuracy) {
        this.targetHistogramAccuracy = targetHistogramAccuracy;
    }

    public static class Builder {
        private int histogramCentroidsLimit = 100;
        private int targetHistogramAccuracy = 32;

        public Builder withTargetHistogramAccuracy(int targetHistogramAccuracy) {
            this.targetHistogramAccuracy = targetHistogramAccuracy;
            return this;
        }

        public Builder throwIfTooManyHistogramCentroids(int histogramCentroidsLimit) {
            this.histogramCentroidsLimit = histogramCentroidsLimit;
            return this;
        }

        public IngesterContext build() {
            return new IngesterContext(this);
        }
    }
}

