/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.ReportPointIngesterFormatter;
import com.wavefront.ingester.ReportableEntityDecoder;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import wavefront.report.ReportPoint;

public class ReportPointDecoder
implements ReportableEntityDecoder<String, ReportPoint> {
    private static final AbstractIngesterFormatter<ReportPoint> FORMAT = ReportPointIngesterFormatter.newBuilder().text(ReportPoint::setMetric).value(ReportPoint::setValue).optionalTimestamp(ReportPoint::setTimestamp).annotationMap(ReportPoint::setAnnotations).build();
    private final Supplier<String> hostNameSupplier;
    private List<String> customSourceTags;

    public ReportPointDecoder(@Nullable Supplier<String> hostNameSupplier, List<String> customSourceTags) {
        this.hostNameSupplier = hostNameSupplier;
        this.customSourceTags = customSourceTags;
    }

    @Override
    public void decode(String msg, List<ReportPoint> out, String customerId) {
        ReportPoint point = FORMAT.drive(msg, this.hostNameSupplier, customerId, this.customSourceTags, null);
        if (out != null) {
            out.add(point);
        }
    }
}

