/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.common;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.base.Splitter;
import com.google.re2j.Pattern;
import com.wavefront.common.TaggedMetricName;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.RunAutomaton;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class PatternMatch
implements Predicate<String> {
    private static final Counter patternsCompiled = Metrics.newCounter((MetricName)new TaggedMetricName("sldb", "patterns.compiled"));
    private static final Counter automatonsCompiled = Metrics.newCounter((MetricName)new TaggedMetricName("sldb", "automatons.compiled"));
    private static final LoadingCache<String, RunAutomaton> automatons = Caffeine.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).maximumSize(100000L).build(key -> {
        automatonsCompiled.inc();
        return PatternMatch.makeAutomaton(key);
    });
    private static final LoadingCache<String, Pattern> patterns = Caffeine.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).maximumSize(100000L).build(key -> {
        patternsCompiled.inc();
        return Pattern.compile((String)key);
    });
    private final RunAutomaton pattern;
    private final boolean caseInsensitive;

    private PatternMatch(String pattern, boolean caseInsensitive) {
        this.pattern = (RunAutomaton)automatons.get((Object)(caseInsensitive ? pattern.toLowerCase() : pattern));
        this.caseInsensitive = caseInsensitive;
    }

    public static Predicate<String> buildPredicate(String pattern, boolean caseInsensitive) {
        char[] chars;
        pattern = pattern.trim();
        if (caseInsensitive) {
            pattern = pattern.toLowerCase();
        }
        boolean startsWithWildcard = (chars = pattern.toCharArray())[0] == '*';
        boolean endsWithWildcard = chars[chars.length - 1] == '*';
        for (int i = 1; i < chars.length - 1; ++i) {
            if (chars[i] != '*') continue;
            return new PatternMatch(pattern, caseInsensitive);
        }
        if (startsWithWildcard && pattern.length() == 1) {
            return s -> true;
        }
        String finalPattern = pattern;
        return x -> {
            if (x == null) {
                return false;
            }
            if (caseInsensitive) {
                x = x.toLowerCase().trim();
            }
            if (startsWithWildcard && endsWithWildcard) {
                return x.contains(finalPattern.substring(1, finalPattern.length() - 1));
            }
            if (startsWithWildcard) {
                return x.endsWith(finalPattern.substring(1));
            }
            if (endsWithWildcard) {
                return x.startsWith(finalPattern.substring(0, finalPattern.length() - 1));
            }
            return x.equals(finalPattern);
        };
    }

    public static Pattern convert(String pattern) {
        Pattern nonStar = (Pattern)patterns.get((Object)"([^*]+)");
        Pattern star = (Pattern)patterns.get((Object)"[*]");
        String input = nonStar.matcher((CharSequence)pattern).replaceAll("\\\\Q$1\\\\E");
        return (Pattern)patterns.get((Object)star.matcher((CharSequence)input).replaceAll("(.*)"));
    }

    public static RunAutomaton makeAutomaton(String pattern) {
        pattern = pattern.trim();
        List components = Splitter.on((String)"*").omitEmptyStrings().splitToList((CharSequence)pattern);
        ArrayList<Automaton> automata = new ArrayList<Automaton>();
        if (pattern.startsWith("*")) {
            automata.add(Automaton.makeAnyString());
        }
        for (int i = 0; i < components.size(); ++i) {
            automata.add(Automaton.makeString((String)((String)components.get(i))));
            if (i >= components.size() - 1) continue;
            automata.add(Automaton.makeAnyString());
        }
        if (pattern.endsWith("*")) {
            automata.add(Automaton.makeAnyString());
        }
        Automaton toReturn = Automaton.concatenate(automata);
        toReturn.minimize();
        return new RunAutomaton(toReturn);
    }

    @Override
    public boolean test(String input) {
        if (this.caseInsensitive) {
            input = input.toLowerCase();
        }
        return this.pattern.run(input);
    }
}

