/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.IngesterContext;
import com.wavefront.ingester.ReportMetricIngesterFormatter;
import com.wavefront.ingester.ReportableEntityDecoder;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import wavefront.report.ReportMetric;

public class ReportMetricDecoder
implements ReportableEntityDecoder<String, ReportMetric> {
    private static final AbstractIngesterFormatter<ReportMetric> FORMAT = ReportMetricIngesterFormatter.newBuilder().text(ReportMetric::setMetric).value(ReportMetric::setValue).optionalTimestamp(ReportMetric::setTimestamp).annotationList(ReportMetric::setAnnotations).build();
    private final Supplier<String> hostNameSupplier;
    private List<String> customSourceTags;

    public ReportMetricDecoder(@Nullable Supplier<String> hostNameSupplier, List<String> customSourceTags) {
        this.hostNameSupplier = hostNameSupplier;
        this.customSourceTags = customSourceTags;
    }

    @Override
    public void decode(String msg, List<ReportMetric> out, String customerId, IngesterContext ctx) {
        ReportMetric point = FORMAT.drive(msg, this.hostNameSupplier, customerId, this.customSourceTags, null);
        if (out != null) {
            out.add(point);
        }
    }
}

