/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.ingester;

import com.wavefront.common.Clock;
import com.wavefront.data.ParseException;
import com.wavefront.ingester.AbstractIngesterFormatter;
import com.wavefront.ingester.IngesterContext;
import com.wavefront.ingester.StringParser;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import wavefront.report.ReportHistogram;

public class ReportHistogramIngesterFormatter
extends AbstractIngesterFormatter<ReportHistogram> {
    private ReportHistogramIngesterFormatter(List<AbstractIngesterFormatter.FormatterElement<ReportHistogram>> elements) {
        super(elements);
    }

    public static AbstractIngesterFormatter.IngesterFormatBuilder<ReportHistogram> newBuilder() {
        return new ReportHistogramIngesterFormatBuilder();
    }

    @Override
    public ReportHistogram drive(String input, Supplier<String> defaultHostNameSupplier, String customerId, @Nullable List<String> customSourceTags, @Nullable IngesterContext ingesterContext) {
        ReportHistogram histogram = new ReportHistogram();
        histogram.setCustomer(customerId);
        histogram.setTimestamp(Clock.now());
        StringParser parser = new StringParser(input);
        for (AbstractIngesterFormatter.FormatterElement element : this.elements) {
            element.consume(parser, histogram);
        }
        if (parser.hasNext()) {
            throw new ParseException("Unexpected extra input: " + parser.next());
        }
        String host = AbstractIngesterFormatter.getHost(histogram.getAnnotations(), customSourceTags);
        if (host == null) {
            host = defaultHostNameSupplier.get();
        }
        histogram.setHost(host);
        return histogram;
    }

    public static class ReportHistogramIngesterFormatBuilder
    extends AbstractIngesterFormatter.IngesterFormatBuilder<ReportHistogram> {
        public ReportHistogramIngesterFormatter build() {
            return new ReportHistogramIngesterFormatter(this.elements);
        }
    }
}

