/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.common.logger;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.util.concurrent.RateLimiter;
import com.wavefront.common.logger.DelegatingLogger;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class MessageDedupingLogger
extends DelegatingLogger {
    private final LoadingCache<String, RateLimiter> rateLimiterCache;

    public MessageDedupingLogger(Logger delegate, long maximumSize, double rateLimit) {
        super(delegate);
        this.rateLimiterCache = Caffeine.newBuilder().expireAfterAccess((long)(2.0 / rateLimit), TimeUnit.SECONDS).maximumSize(maximumSize).build(x -> RateLimiter.create((double)rateLimit));
    }

    @Override
    public void log(Level level, String message) {
        if (Objects.requireNonNull((RateLimiter)this.rateLimiterCache.get((Object)message)).tryAcquire()) {
            this.log(new LogRecord(level, message));
        }
    }
}

