/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.common.logger;

import com.google.common.util.concurrent.RateLimiter;
import com.wavefront.common.logger.DelegatingLogger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class SharedRateLimitingLogger
extends DelegatingLogger {
    private static final Map<String, RateLimiter> SHARED_CACHE = new ConcurrentHashMap<String, RateLimiter>();
    private final RateLimiter rateLimiter;

    public SharedRateLimitingLogger(Logger delegate, String context, double rateLimit) {
        super(delegate);
        this.rateLimiter = SHARED_CACHE.computeIfAbsent(context, x -> RateLimiter.create((double)rateLimit));
    }

    @Override
    public void log(Level level, String message) {
        if (!this.delegate.isLoggable(level)) {
            return;
        }
        if (this.rateLimiter.tryAcquire()) {
            this.log(new LogRecord(level, message));
        }
    }

    @Override
    public void log(Level level, Supplier<String> messageSupplier) {
        if (!this.delegate.isLoggable(level)) {
            return;
        }
        if (this.rateLimiter.tryAcquire()) {
            this.log(new LogRecord(level, messageSupplier.get()));
        }
    }
}

