/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.data;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.RateLimiter;
import com.wavefront.api.agent.ValidationConfiguration;
import com.wavefront.data.AnnotationUtils;
import com.wavefront.data.DataValidationException;
import com.wavefront.data.DeltaCounterValueException;
import com.wavefront.data.EmptyHistogramException;
import com.wavefront.data.EmptyTagValueException;
import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.MetricName;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import wavefront.report.Annotation;
import wavefront.report.Histogram;
import wavefront.report.ReportHistogram;
import wavefront.report.ReportLog;
import wavefront.report.ReportMetric;
import wavefront.report.ReportPoint;
import wavefront.report.Span;
import wavefront.report.SpanLog;
import wavefront.report.SpanLogs;

public class Validation {
    static final String LOG_SOURCE_REQUIRED_ERROR = "WF-450: Log source/host name is required";
    static final String LOG_SOURCE_TOO_LONG_ERROR = "WF-451: Log source/host name is too long (%s characters, max: %s): %s";
    static final String LOG_MESSAGE_TOO_LONG_ERROR = "WF-452: log message is too long (%s characters, max: %s): %s";
    static final String LOG_TOO_MANY_ANNOTATIONS_ERROR = "WF-453: Too many log tags (%s, max %s)";
    static final String LOG_TAG_KEY_TOO_LONG_ERROR = "WF-454: Log tag key is too long (%s characters, max: %s): %s";
    static final String LOG_TAG_KEY_ILLEGAL_CHAR_ERROR = "WF-455: Log tag key has illegal character(s): %s";
    static final String LOG_ANNOTATION_NO_VALUE_ERROR = "WF-456: log tag value for %s is empty or missing";
    static final String LOG_ANNOTATION_VALUE_TOO_LONG_ERROR = "WF-457: Log tag value is too long (%s characters, max: %s): %s";
    private static final LoadingCache<String, Counter> ERROR_COUNTERS = Caffeine.newBuilder().build(x -> Metrics.newCounter((MetricName)new MetricName("point", "", x)));
    private static final LoadingCache<String, Counter> LOG_ERROR_COUNTERS = Caffeine.newBuilder().build(x -> Metrics.newCounter((MetricName)new MetricName("log", "", x)));
    private static final RateLimiter blockedLoggingRateLimiter = RateLimiter.create((double)1.0);
    private static final Logger logger = Logger.getLogger(Validation.class.getCanonicalName());

    public static boolean charactersAreValid(String input) {
        int l = input.length();
        if (l == 0) {
            return false;
        }
        boolean isTildaPrefixed = input.charAt(0) == '~';
        boolean isDeltaPrefixed = input.charAt(0) == '\u2206' || input.charAt(0) == '\u0394';
        boolean isDeltaTildaPrefixed = isDeltaPrefixed && input.charAt(1) == '~';
        for (int i = 0; i < l; ++i) {
            char cur = input.charAt(i);
            if (',' <= cur && cur <= '9' || 'A' <= cur && cur <= 'Z' || 'a' <= cur && cur <= 'z' || cur == '_' || i == 0 && (isDeltaPrefixed || isTildaPrefixed) || i == 1 && isDeltaTildaPrefixed) continue;
            return false;
        }
        return true;
    }

    public static boolean logCharactersAreValid(String input) {
        int l = input.length();
        if (l == 0) {
            return false;
        }
        char start = input.charAt(0);
        if ('0' <= start && start <= '9') {
            return false;
        }
        if (start == '_' || input.charAt(input.length() - 1) == '_') {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            char cur = input.charAt(i);
            if ('0' <= cur && cur <= '9' || 'A' <= cur && cur <= 'Z' || 'a' <= cur && cur <= 'z' || cur == '_') continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static boolean annotationKeysAreValid(Map<String, String> annotations) {
        for (String key : annotations.keySet()) {
            if (Validation.charactersAreValid(key)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static boolean annotationKeysAreValid(List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            if (Validation.charactersAreValid(annotation.getKey())) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static void validatePoint(ReportPoint point, @Nullable ValidationConfiguration config) {
        if (config == null) {
            return;
        }
        String host = point.getHost();
        String metric = point.getMetric();
        Object value = point.getValue();
        boolean isHistogram = value instanceof Histogram;
        if (StringUtils.isBlank((String)host)) {
            ((Counter)ERROR_COUNTERS.get((Object)"sourceMissing")).inc();
            throw new DataValidationException("WF-406: Source/host name is required");
        }
        if (host.length() > config.getHostLengthLimit()) {
            ((Counter)ERROR_COUNTERS.get((Object)"sourceTooLong")).inc();
            throw new DataValidationException("WF-407: Source/host name is too long (" + host.length() + " characters, max: " + config.getHostLengthLimit() + "): " + host);
        }
        if (isHistogram) {
            if (metric.length() > config.getHistogramLengthLimit()) {
                ((Counter)ERROR_COUNTERS.get((Object)"histogramNameTooLong")).inc();
                throw new DataValidationException("WF-409: Histogram name is too long (" + metric.length() + " characters, max: " + config.getHistogramLengthLimit() + "): " + metric);
            }
        } else if (metric.length() > config.getMetricLengthLimit()) {
            ((Counter)ERROR_COUNTERS.get((Object)"metricNameTooLong")).inc();
            throw new DataValidationException("WF-408: Metric name is too long (" + metric.length() + " characters, max: " + config.getMetricLengthLimit() + "): " + metric);
        }
        if (!Validation.charactersAreValid(metric)) {
            ((Counter)ERROR_COUNTERS.get((Object)"badchars")).inc();
            throw new DataValidationException("WF-400: Point metric has illegal character(s): " + metric);
        }
        Map<String, String> annotations = point.getAnnotations();
        if (annotations != null) {
            if (annotations.size() > config.getAnnotationsCountLimit()) {
                ((Counter)ERROR_COUNTERS.get((Object)"tooManyPointTags")).inc();
                throw new DataValidationException("WF-410: Too many point tags (" + annotations.size() + ", max " + config.getAnnotationsCountLimit() + "): ");
            }
            for (Map.Entry<String, String> tag : annotations.entrySet()) {
                String tagK = tag.getKey();
                String tagV = tag.getValue();
                if (tagK.length() + tagV.length() >= 255) {
                    ((Counter)ERROR_COUNTERS.get((Object)"pointTagTooLong")).inc();
                    throw new DataValidationException("WF-411: Point tag (key+value) too long (" + (tagK.length() + tagV.length() + 1) + " characters, max: 255): " + tagK + "=" + tagV);
                }
                if (tagK.length() > config.getAnnotationsKeyLengthLimit()) {
                    ((Counter)ERROR_COUNTERS.get((Object)"pointTagKeyTooLong")).inc();
                    throw new DataValidationException("WF-412: Point tag key is too long (" + tagK.length() + " characters, max: " + config.getAnnotationsKeyLengthLimit() + "): " + tagK);
                }
                if (!Validation.charactersAreValid(tagK)) {
                    ((Counter)ERROR_COUNTERS.get((Object)"badchars")).inc();
                    throw new DataValidationException("WF-401: Point tag key has illegal character(s): " + tagK);
                }
                if (StringUtils.isBlank((String)tagV)) {
                    ((Counter)ERROR_COUNTERS.get((Object)"pointTagValueEmpty")).inc();
                    throw new EmptyTagValueException("WF-414: Point tag value for " + tagK + " is empty or missing");
                }
                if (tagV.length() <= config.getAnnotationsValueLengthLimit()) continue;
                ((Counter)ERROR_COUNTERS.get((Object)"pointTagValueTooLong")).inc();
                throw new DataValidationException("WF-413: Point tag value is too long (" + tagV.length() + " characters, max: " + config.getAnnotationsValueLengthLimit() + "): " + tagV);
            }
        }
        if (!(value instanceof Double || value instanceof Long || value instanceof Histogram)) {
            throw new DataValidationException("WF-403: Value is not a long/double/histogram object: " + value);
        }
        if (value instanceof Histogram) {
            Histogram histogram = (Histogram)((Object)value);
            if (histogram.getCounts().size() == 0 || histogram.getBins().size() == 0 || histogram.getCounts().stream().allMatch(i -> i == 0)) {
                throw new EmptyHistogramException("WF-405: Empty histogram");
            }
        } else if ((metric.charAt(0) == '\u2206' || metric.charAt(0) == '\u0394') && ((Number)value).doubleValue() <= 0.0) {
            throw new DeltaCounterValueException("WF-404: Delta metrics cannot be non-positive");
        }
    }

    public static void validateMetric(ReportMetric point, @Nullable ValidationConfiguration config) {
        if (config == null) {
            return;
        }
        String host = point.getHost();
        String metric = point.getMetric();
        if (StringUtils.isBlank((String)host)) {
            ((Counter)ERROR_COUNTERS.get((Object)"sourceMissing")).inc();
            throw new DataValidationException("WF-406: Source/host name is required");
        }
        if (host.length() > config.getHostLengthLimit()) {
            ((Counter)ERROR_COUNTERS.get((Object)"sourceTooLong")).inc();
            throw new DataValidationException("WF-407: Source/host name is too long (" + host.length() + " characters, max: " + config.getHostLengthLimit() + "): " + host);
        }
        if (metric.length() > config.getMetricLengthLimit()) {
            ((Counter)ERROR_COUNTERS.get((Object)"metricNameTooLong")).inc();
            throw new DataValidationException("WF-408: Metric name is too long (" + metric.length() + " characters, max: " + config.getMetricLengthLimit() + "): " + metric);
        }
        if (!Validation.charactersAreValid(metric)) {
            ((Counter)ERROR_COUNTERS.get((Object)"badchars")).inc();
            throw new DataValidationException("WF-400: Point metric has illegal character(s): " + metric);
        }
        List<Annotation> annotations = point.getAnnotations();
        if (annotations != null) {
            if (annotations.size() > config.getAnnotationsCountLimit()) {
                ((Counter)ERROR_COUNTERS.get((Object)"tooManyPointTags")).inc();
                throw new DataValidationException("WF-410: Too many point tags (" + annotations.size() + ", max " + config.getAnnotationsCountLimit() + "): ");
            }
            for (Annotation tag : annotations) {
                String tagK = tag.getKey();
                String tagV = tag.getValue();
                if (tagK.length() + tagV.length() >= 255) {
                    ((Counter)ERROR_COUNTERS.get((Object)"pointTagTooLong")).inc();
                    throw new DataValidationException("WF-411: Point tag (key+value) too long (" + (tagK.length() + tagV.length() + 1) + " characters, max: 255): " + tagK + "=" + tagV);
                }
                if (tagK.length() > config.getAnnotationsKeyLengthLimit()) {
                    ((Counter)ERROR_COUNTERS.get((Object)"pointTagKeyTooLong")).inc();
                    throw new DataValidationException("WF-412: Point tag key is too long (" + tagK.length() + " characters, max: " + config.getAnnotationsKeyLengthLimit() + "): " + tagK);
                }
                if (!Validation.charactersAreValid(tagK)) {
                    ((Counter)ERROR_COUNTERS.get((Object)"badchars")).inc();
                    throw new DataValidationException("WF-401: Point tag key has illegal character(s): " + tagK);
                }
                if (StringUtils.isBlank((String)tagV)) {
                    ((Counter)ERROR_COUNTERS.get((Object)"pointTagValueEmpty")).inc();
                    throw new EmptyTagValueException("WF-414: Point tag value for " + tagK + " is empty or missing");
                }
                if (tagV.length() <= config.getAnnotationsValueLengthLimit()) continue;
                ((Counter)ERROR_COUNTERS.get((Object)"pointTagValueTooLong")).inc();
                throw new DataValidationException("WF-413: Point tag value is too long (" + tagV.length() + " characters, max: " + config.getAnnotationsValueLengthLimit() + "): " + tagV);
            }
        }
        if ((metric.charAt(0) == '\u2206' || metric.charAt(0) == '\u0394') && point.getValue() <= 0.0) {
            throw new DeltaCounterValueException("WF-404: Delta metrics cannot be non-positive");
        }
    }

    public static void validateHistogram(ReportHistogram histogram, @Nullable ValidationConfiguration config) {
        Histogram value;
        if (config == null) {
            return;
        }
        String host = histogram.getHost();
        String metric = histogram.getMetric();
        if (StringUtils.isBlank((String)host)) {
            ((Counter)ERROR_COUNTERS.get((Object)"sourceMissing")).inc();
            throw new DataValidationException("WF-406: Source/host name is required");
        }
        if (host.length() > config.getHostLengthLimit()) {
            ((Counter)ERROR_COUNTERS.get((Object)"sourceTooLong")).inc();
            throw new DataValidationException("WF-407: Source/host name is too long (" + host.length() + " characters, max: " + config.getHostLengthLimit() + "): " + host);
        }
        if (metric.length() > config.getHistogramLengthLimit()) {
            ((Counter)ERROR_COUNTERS.get((Object)"histogramNameTooLong")).inc();
            throw new DataValidationException("WF-409: Histogram name is too long (" + metric.length() + " characters, max: " + config.getHistogramLengthLimit() + "): " + metric);
        }
        if (!Validation.charactersAreValid(metric)) {
            ((Counter)ERROR_COUNTERS.get((Object)"badchars")).inc();
            throw new DataValidationException("WF-400: Point metric has illegal character(s): " + metric);
        }
        List<Annotation> annotations = histogram.getAnnotations();
        if (annotations != null) {
            if (annotations.size() > config.getAnnotationsCountLimit()) {
                ((Counter)ERROR_COUNTERS.get((Object)"tooManyPointTags")).inc();
                throw new DataValidationException("WF-410: Too many point tags (" + annotations.size() + ", max " + config.getAnnotationsCountLimit() + "): ");
            }
            for (Annotation tag : annotations) {
                String tagK = tag.getKey();
                String tagV = tag.getValue();
                if (tagK.length() + tagV.length() >= 255) {
                    ((Counter)ERROR_COUNTERS.get((Object)"pointTagTooLong")).inc();
                    throw new DataValidationException("WF-411: Point tag (key+value) too long (" + (tagK.length() + tagV.length() + 1) + " characters, max: 255): " + tagK + "=" + tagV);
                }
                if (tagK.length() > config.getAnnotationsKeyLengthLimit()) {
                    ((Counter)ERROR_COUNTERS.get((Object)"pointTagKeyTooLong")).inc();
                    throw new DataValidationException("WF-412: Point tag key is too long (" + tagK.length() + " characters, max: " + config.getAnnotationsKeyLengthLimit() + "): " + tagK);
                }
                if (!Validation.charactersAreValid(tagK)) {
                    ((Counter)ERROR_COUNTERS.get((Object)"badchars")).inc();
                    throw new DataValidationException("WF-401: Point tag key has illegal character(s): " + tagK);
                }
                if (StringUtils.isBlank((String)tagV)) {
                    ((Counter)ERROR_COUNTERS.get((Object)"pointTagValueEmpty")).inc();
                    throw new EmptyTagValueException("WF-414: Point tag value for " + tagK + " is empty or missing");
                }
                if (tagV.length() <= config.getAnnotationsValueLengthLimit()) continue;
                ((Counter)ERROR_COUNTERS.get((Object)"pointTagValueTooLong")).inc();
                throw new DataValidationException("WF-413: Point tag value is too long (" + tagV.length() + " characters, max: " + config.getAnnotationsValueLengthLimit() + "): " + tagV);
            }
        }
        if ((value = histogram.getValue()).getCounts().size() == 0 || value.getBins().size() == 0 || value.getCounts().stream().allMatch(i -> i == 0)) {
            throw new EmptyHistogramException("WF-405: Empty histogram");
        }
    }

    public static void validateSpan(Span span, @Nullable ValidationConfiguration config) {
        Validation.validateSpan(span, config, null);
    }

    public static void validateSpan(Span span, @Nullable ValidationConfiguration config, @Nullable Consumer<SpanLogs> spanLogsReporter) {
        if (config == null) {
            return;
        }
        String source = span.getSource();
        String spanName = span.getName();
        if (StringUtils.isBlank((String)source)) {
            ((Counter)ERROR_COUNTERS.get((Object)"spanSourceMissing")).inc();
            throw new DataValidationException("WF-426: Span source/host name is required");
        }
        if (source.length() > config.getHostLengthLimit()) {
            ((Counter)ERROR_COUNTERS.get((Object)"spanSourceTooLong")).inc();
            throw new DataValidationException("WF-427: Span source/host name is too long (" + source.length() + " characters, max: " + config.getHostLengthLimit() + "): " + source);
        }
        if (spanName.length() > config.getSpanLengthLimit()) {
            ((Counter)ERROR_COUNTERS.get((Object)"spanNameTooLong")).inc();
            throw new DataValidationException("WF-428: Span name is too long (" + spanName.length() + " characters, max: " + config.getSpanLengthLimit() + "): " + spanName);
        }
        if (spanName.contains("*")) {
            ((Counter)ERROR_COUNTERS.get((Object)"spanNameBadChars")).inc();
            throw new DataValidationException("WF-415: Span name has illegal character *: " + spanName);
        }
        List<Annotation> annotations = span.getAnnotations();
        if (annotations != null) {
            if (annotations.size() > config.getSpanAnnotationsCountLimit()) {
                ((Counter)ERROR_COUNTERS.get((Object)"spanTooManyAnnotations")).inc();
                throw new DataValidationException("WF-430: Span has too many annotations (" + annotations.size() + ", max " + config.getSpanAnnotationsCountLimit() + ")");
            }
            HashMap<String, String> annotationsWithOversizedValue = spanLogsReporter == null ? null : new HashMap<String, String>();
            for (Annotation annotation : annotations) {
                String tagK = annotation.getKey();
                String tagV = annotation.getValue();
                if (tagK.length() > config.getSpanAnnotationsKeyLengthLimit()) {
                    ((Counter)ERROR_COUNTERS.get((Object)"spanAnnotationKeyTooLong")).inc();
                    throw new DataValidationException("WF-432: Span annotation key is too long (" + tagK.length() + " characters, max: " + config.getSpanAnnotationsKeyLengthLimit() + "): " + tagK);
                }
                if (!Validation.charactersAreValid(tagK)) {
                    ((Counter)ERROR_COUNTERS.get((Object)"spanAnnotationKeyBadChars")).inc();
                    throw new DataValidationException("WF-416: Span annotation key has illegal character(s): " + tagK);
                }
                if (StringUtils.isBlank((String)tagV)) {
                    ((Counter)ERROR_COUNTERS.get((Object)"spanAnnotationValueEmpty")).inc();
                    throw new EmptyTagValueException("WF-434: Span annotation value for " + tagK + " is empty or missing ");
                }
                if (tagV.length() <= config.getSpanAnnotationsValueLengthLimit()) continue;
                if (blockedLoggingRateLimiter.tryAcquire()) {
                    logger.warning("WF-433: Span annotation value for " + tagK + " is too long (" + tagV.length() + " characters, max: " + config.getSpanAnnotationsValueLengthLimit() + "), value will be truncated: " + tagV);
                }
                annotation.setValue(tagV.substring(0, config.getSpanAnnotationsValueLengthLimit()));
                if (annotationsWithOversizedValue != null) {
                    annotationsWithOversizedValue.put(tagK, tagV);
                }
                ((Counter)ERROR_COUNTERS.get((Object)"spanAnnotationValueTruncated")).inc();
            }
            if (annotationsWithOversizedValue != null && !annotationsWithOversizedValue.isEmpty()) {
                if (!annotations.stream().filter(x -> x.getKey().equals("_spanLogs")).peek(x -> x.setValue(Boolean.toString(true))).findAny().isPresent()) {
                    span.getAnnotations().add(new Annotation("_spanLogs", Boolean.toString(true)));
                }
                SpanLog spanLog = SpanLog.newBuilder().setTimestamp(-1L).setFields(annotationsWithOversizedValue).build();
                SpanLogs spanLogs = SpanLogs.newBuilder().setCustomer(span.getCustomer()).setTraceId(span.getTraceId()).setSpanId(span.getSpanId()).setSpanSecondaryId(AnnotationUtils.getValue(annotations, "_spanSecondaryId")).setLogs((List<SpanLog>)ImmutableList.of((Object)((Object)spanLog))).build();
                spanLogsReporter.accept(spanLogs);
            }
        }
    }

    public static void validateLog(ReportLog log, @Nullable ValidationConfiguration config) {
        if (config == null) {
            return;
        }
        String source = log.getHost();
        String message = log.getMessage();
        if (StringUtils.isBlank((String)source)) {
            ((Counter)LOG_ERROR_COUNTERS.get((Object)"logSourceMissing")).inc();
            throw new DataValidationException(LOG_SOURCE_REQUIRED_ERROR);
        }
        if (source.length() > config.getHostLengthLimit()) {
            ((Counter)LOG_ERROR_COUNTERS.get((Object)"logSourceTooLong")).inc();
            throw new DataValidationException(String.format(LOG_SOURCE_TOO_LONG_ERROR, source.length(), config.getHostLengthLimit(), source));
        }
        if (message.length() > config.getLogLengthLimit()) {
            ((Counter)LOG_ERROR_COUNTERS.get((Object)"logMessageTooLong")).inc();
            throw new DataValidationException(String.format(LOG_MESSAGE_TOO_LONG_ERROR, message.length(), config.getLogLengthLimit(), message));
        }
        List<Annotation> annotations = log.getAnnotations();
        if (annotations != null) {
            if (annotations.size() > config.getLogAnnotationsCountLimit()) {
                ((Counter)LOG_ERROR_COUNTERS.get((Object)"tooManyLogTags")).inc();
                throw new DataValidationException(String.format(LOG_TOO_MANY_ANNOTATIONS_ERROR, annotations.size(), config.getLogAnnotationsCountLimit()));
            }
            for (Annotation tag : annotations) {
                String tagK = tag.getKey();
                String tagV = tag.getValue();
                if (tagK.length() > config.getLogAnnotationsKeyLengthLimit()) {
                    ((Counter)LOG_ERROR_COUNTERS.get((Object)"logAnnotationKeyTooLong")).inc();
                    throw new DataValidationException(String.format(LOG_TAG_KEY_TOO_LONG_ERROR, tagK.length(), config.getLogAnnotationsKeyLengthLimit(), tagK));
                }
                if (!Validation.logCharactersAreValid(tagK)) {
                    ((Counter)LOG_ERROR_COUNTERS.get((Object)"logAnnotationKeyBadChars")).inc();
                    throw new DataValidationException(String.format(LOG_TAG_KEY_ILLEGAL_CHAR_ERROR, tagK));
                }
                if (StringUtils.isBlank((String)tagV)) {
                    ((Counter)LOG_ERROR_COUNTERS.get((Object)"logAnnotationValueEmpty")).inc();
                    throw new EmptyTagValueException(String.format(LOG_ANNOTATION_NO_VALUE_ERROR, tagK));
                }
                if (tagV.length() <= config.getLogAnnotationsValueLengthLimit()) continue;
                ((Counter)LOG_ERROR_COUNTERS.get((Object)"logAnnotationValueTooLong")).inc();
                throw new DataValidationException(String.format(LOG_ANNOTATION_VALUE_TOO_LONG_ERROR, tagV.length(), config.getLogAnnotationsValueLengthLimit(), tagV));
            }
        }
    }

    @Deprecated
    public static void validatePoint(ReportPoint point, String source, @Nullable Level validationLevel) {
        Object pointValue = point.getValue();
        if (StringUtils.isBlank((String)point.getHost())) {
            throw new DataValidationException("WF-301: Source/host name is required");
        }
        if (point.getHost().length() >= 1024) {
            throw new DataValidationException("WF-301: Source/host name is too long: " + point.getHost());
        }
        if (point.getMetric().length() >= 1024) {
            throw new DataValidationException("WF-301: Metric name is too long: " + point.getMetric());
        }
        if (!Validation.charactersAreValid(point.getMetric())) {
            ((Counter)ERROR_COUNTERS.get((Object)"badchars")).inc();
            throw new DataValidationException("WF-400 " + source + ": Point metric has illegal character");
        }
        if (point.getAnnotations() != null) {
            if (!Validation.annotationKeysAreValid(point.getAnnotations())) {
                throw new DataValidationException("WF-401 " + source + ": Point annotation key has illegal character");
            }
            for (Map.Entry<String, String> tag : point.getAnnotations().entrySet()) {
                if (tag.getKey().length() + tag.getValue().length() < 255) continue;
                throw new DataValidationException("Tag too long: " + tag.getKey() + "=" + tag.getValue());
            }
        }
        if (validationLevel != null && !validationLevel.equals((Object)Level.NO_VALIDATION)) {
            switch (validationLevel) {
                case NUMERIC_ONLY: {
                    Histogram histogram;
                    if (!(pointValue instanceof Long || pointValue instanceof Double || pointValue instanceof Histogram)) {
                        throw new DataValidationException("WF-403 " + source + ": Was not long/double/histogram object");
                    }
                    if (!(pointValue instanceof Histogram) || (histogram = (Histogram)((Object)pointValue)).getCounts().size() != 0 && histogram.getBins().size() != 0 && !histogram.getCounts().stream().allMatch(i -> i == 0)) break;
                    throw new DataValidationException("WF-405 " + source + ": Empty histogram");
                }
            }
        }
    }

    public static enum Level {
        NO_VALIDATION,
        NUMERIC_ONLY;

    }
}

