/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.common;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class MetricMangler {
    private final List<Integer> hostIndices = new ArrayList<Integer>();
    private int maxField = 0;
    private final Set<Integer> hostIndexSet = new HashSet<Integer>();
    @Nullable
    private final String delimiters;
    private final Set<Integer> removeIndexSet = new HashSet<Integer>();

    public MetricMangler(@Nullable String sourceFields, @Nullable String delimiters, @Nullable String removeFields) {
        int fieldIndex;
        Iterable fields;
        if (sourceFields != null) {
            fields = Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)sourceFields);
            for (String field : fields) {
                if (field.trim().length() <= 0) continue;
                fieldIndex = Integer.parseInt(field);
                if (fieldIndex <= 0) {
                    throw new IllegalArgumentException("Can't define a field of index 0 or less; indices must be 1-based");
                }
                this.hostIndices.add(fieldIndex - 1);
                this.hostIndexSet.add(fieldIndex - 1);
                if (fieldIndex <= this.maxField) continue;
                this.maxField = fieldIndex;
            }
        }
        if (removeFields != null) {
            fields = Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)removeFields);
            for (String field : fields) {
                if (field.trim().length() <= 0) continue;
                fieldIndex = Integer.parseInt(field);
                if (fieldIndex <= 0) {
                    throw new IllegalArgumentException("Can't define a field to remove of index 0 or less; indices must be 1-based");
                }
                this.removeIndexSet.add(fieldIndex - 1);
            }
        }
        this.delimiters = delimiters;
    }

    public MetricComponents extractComponents(String metric) {
        String[] segments = metric.split("\\.");
        MetricComponents rtn = new MetricComponents();
        if (segments.length < this.maxField) {
            throw new IllegalArgumentException(String.format("Metric data |%s| provided was incompatible with format.", metric));
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < segments.length; ++i) {
            String segment = segments[i];
            if (this.hostIndexSet.contains(i) || this.removeIndexSet.contains(i)) continue;
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(segment);
        }
        rtn.metric = buf.toString();
        if (rtn.metric.indexOf(";") > 0) {
            String[] annotationSegments = rtn.metric.split(";");
            rtn.annotations = Arrays.copyOfRange(annotationSegments, 1, annotationSegments.length);
            rtn.metric = annotationSegments[0];
        }
        if (this.hostIndices != null && !this.hostIndices.isEmpty()) {
            buf = new StringBuilder();
            for (int f = 0; f < this.hostIndices.size(); ++f) {
                char[] segmentChars = segments[this.hostIndices.get(f)].toCharArray();
                if (this.delimiters != null && !this.delimiters.isEmpty()) {
                    for (int i = 0; i < segmentChars.length; ++i) {
                        for (int c = 0; c < this.delimiters.length(); ++c) {
                            if (segmentChars[i] != this.delimiters.charAt(c)) continue;
                            segmentChars[i] = 46;
                        }
                    }
                }
                if (f > 0) {
                    buf.append('.');
                }
                buf.append(segmentChars);
            }
            rtn.source = buf.toString();
        } else {
            rtn.source = null;
        }
        return rtn;
    }

    public static class MetricComponents {
        @Nullable
        public String source;
        @Nullable
        public String metric;
        @Nullable
        public String[] annotations;
    }
}

