/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.common;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class EvictingRingBuffer<T>
extends AbstractCollection<T>
implements Queue<T>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = -4686283540164095706L;
    private final List<T> buffer;
    private final int bufferSize;
    private int headPtr;
    private int tailPtr;
    private final boolean throwOnOverflow;

    public EvictingRingBuffer(int capacity) {
        this(capacity, false, null, false);
    }

    public EvictingRingBuffer(int capacity, boolean throwOnOverflow) {
        this(capacity, throwOnOverflow, null, false);
    }

    public EvictingRingBuffer(int capacity, @Nullable T defaultValue) {
        this(capacity, false, defaultValue, true);
    }

    public EvictingRingBuffer(int capacity, boolean throwOnOverflow, @Nullable T defaultValue) {
        this(capacity, throwOnOverflow, defaultValue, true);
    }

    protected EvictingRingBuffer(int capacity, boolean throwOnOverflow, @Nullable T defaultValue, boolean preFill) {
        this.buffer = new ArrayList<T>(Collections.nCopies(capacity + 1, defaultValue));
        this.buffer.set(0, null);
        this.bufferSize = capacity + 1;
        this.throwOnOverflow = throwOnOverflow;
        this.headPtr = 0;
        this.tailPtr = preFill ? capacity : 0;
    }

    public int capacity() {
        return this.bufferSize - 1;
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.toList().iterator();
    }

    @Override
    public int size() {
        return this.tailPtr - this.headPtr + (this.tailPtr < this.headPtr ? this.bufferSize : 0);
    }

    public T get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + index + ", expected: [0; " + this.size() + ")");
        }
        return this.buffer.get(this.wrap(this.headPtr + index + 1));
    }

    @Override
    public boolean add(T value) {
        if (this.offer(value)) {
            return true;
        }
        throw new IllegalStateException("Buffer capacity exceeded: " + (this.bufferSize - 1));
    }

    @Override
    public boolean offer(T value) {
        if (this.size() == this.bufferSize - 1) {
            if (this.throwOnOverflow) {
                return false;
            }
            this.headPtr = this.wrap(this.headPtr + 1);
            this.buffer.set(this.headPtr, null);
        }
        this.tailPtr = this.wrap(this.tailPtr + 1);
        this.buffer.set(this.tailPtr, value);
        return true;
    }

    public List<T> toList() {
        if (this.tailPtr == this.headPtr) {
            return Collections.emptyList();
        }
        if (this.tailPtr > this.headPtr) {
            return Collections.unmodifiableList(this.buffer.subList(this.headPtr + 1, this.tailPtr + 1));
        }
        return Collections.unmodifiableList(Stream.concat(this.buffer.subList(this.headPtr + 1, this.bufferSize).stream(), this.buffer.subList(0, this.tailPtr + 1).stream()).collect(Collectors.toList()));
    }

    @Override
    @Nonnull
    public Object[] toArray() {
        if (this.tailPtr == this.headPtr) {
            return new Object[0];
        }
        if (this.tailPtr > this.headPtr) {
            return this.buffer.subList(this.headPtr + 1, this.tailPtr + 1).toArray();
        }
        return Stream.concat(this.buffer.subList(this.headPtr + 1, this.bufferSize).stream(), this.buffer.subList(0, this.tailPtr + 1).stream()).toArray();
    }

    @Override
    public T remove() {
        T t = this.poll();
        if (t == null) {
            throw new NoSuchElementException("No elements available");
        }
        return t;
    }

    @Override
    public T poll() {
        if (this.size() == 0) {
            return null;
        }
        T t = this.get(0);
        this.headPtr = this.wrap(this.headPtr + 1);
        this.buffer.set(this.headPtr, null);
        return t;
    }

    @Override
    public T element() {
        T t = this.peek();
        if (t == null) {
            throw new NoSuchElementException("No elements available");
        }
        return t;
    }

    @Override
    public T peek() {
        if (this.size() == 0) {
            return null;
        }
        return this.get(0);
    }

    @Override
    public int hashCode() {
        int result = this.capacity();
        result = 31 * result + this.size();
        for (int i = 0; i < this.size(); ++i) {
            T item = this.get(i);
            result = 31 * result + (item == null ? 0 : item.hashCode());
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof EvictingRingBuffer)) {
            return false;
        }
        EvictingRingBuffer other = (EvictingRingBuffer)obj;
        if (this.capacity() != other.capacity()) {
            return false;
        }
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private int wrap(int index) {
        int m = index % this.bufferSize;
        return m < 0 ? m + this.bufferSize : m;
    }
}

